% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-helper.R
\name{check_ppp_vector_validity}
\alias{check_ppp_vector_validity}
\title{Check the validity of a ppp vector.}
\usage{
check_ppp_vector_validity(
  times,
  t_min,
  t_max = NULL,
  size = NULL,
  atmost1 = FALSE,
  atleast1 = FALSE
)
}
\arguments{
\item{times}{(vector, double) the times to be checked}

\item{t_min}{(double) the start of the time nterval}

\item{t_max}{(double) optional: the end of the time interval}

\item{size}{(double) optional: the size of the vector}

\item{atmost1}{(boolean) optional: at most one sample returned}

\item{atleast1}{(boolean) optional: at least one sample returned}
}
\value{
None
}
\description{
Standard checks for a vector of ordered times. Check
that the \code{times} vector is sorted, has unique values, has all values
in \verb{[t_min, t_max]}, and has length \code{size} (if applicable).
}
