% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche.runif.R
\name{niche.runif}
\alias{niche.runif}
\title{Uniform sampling from an elliptical niche region.}
\usage{
niche.runif(n, mu, Sigma, alpha = 0.95)
}
\arguments{
\item{n}{Number of random draws.}

\item{mu}{Mean vector.}

\item{Sigma}{Variance matrix.}

\item{alpha}{Probabilistic niche size}
}
\value{
IID draws from a uniform distribution on the elliptical niche region.
}
\description{
Uniform sampling from an elliptical niche region.
}
\examples{
# 2d example
d <- 2 # number of dimensions
V <- crossprod(matrix(rnorm(4),d,d))
mu <- rnorm(d)
plot(ellipse(mu, V), type = "l")
points(niche.runif(1e4, mu, V), col = "brown", pch = ".")
}
\seealso{
\code{\link[=ellipse]{ellipse()}} and \code{\link[=niche.size]{niche.size()}} for the definition of the elliptical niche region.
}
