% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp1.R
\name{Exp1}
\alias{Exp1}
\alias{dexp1}
\alias{pexp1}
\alias{qexp1}
\alias{rexp1}
\title{Density, Distribution Function, Quantile Function and
Random Generation for the One-Parameter Exponential Distribution}
\usage{
dexp1(x, scale = 1, log = FALSE, deriv = FALSE, hessian = FALSE)

pexp1(q, scale = 1, lower.tail = TRUE, deriv = FALSE, hessian = FALSE)

qexp1(p, scale = 1, lower.tail = TRUE, deriv = FALSE, hessian = FALSE)

rexp1(n, scale = 1)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{scale}{Scale parameter. Numeric vector with suitable length,
see \bold{Details}.}

\item{log}{Logical; if \code{TRUE}, densities \code{p} are
returned as \code{log(p)}.}

\item{deriv}{Logical. If \code{TRUE}, the gradient of each
computed value w.r.t. the parameter vector is computed, and
returned as a \code{"gradient"} attribute of the result. This is a
numeric array with dimension \code{c(n, 1)} where \code{n} is the
length of the first argument, i.e. \code{x}, \code{p} or \code{q},
depending on the function.}

\item{hessian}{Logical. If \code{TRUE}, the Hessian of each
computed value w.r.t. the parameter vector is computed, and
returned as a \code{"hessian"} attribute of the result. This is a
numeric array with dimension \code{c(n, 1, 1)} where \code{n} is
the length of the first argument, i.e. \code{x}, \code{p} or
depending on the function.}

\item{lower.tail}{Logical; if \code{TRUE} (default), probabilities
are \eqn{\textrm{Pr}[X \leq x]}{Pr[X <= x]}, otherwise,
\eqn{\textrm{Pr}[X > x]}{Pr[X < x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Sample size.}
}
\value{
A numeric vector with its length equal to the maximum of
    the two lengths: that of the first argument and that of the
    parameter \code{scale}. When \code{deriv} is \code{TRUE}, the
    returned value has an attribute named \code{"gradient"} which
    is a matrix with \eqn{n} lines and \eqn{1} column containing
    the derivative. A row contains the partial derivative of the
    corresponding element w.r.t. the parameter \code{"scale"}.
}
\description{
Density, distribution function, quantile function and random
generation for the one-parameter Exponential Distribution
distribution with scale parameter \code{scale}.
}
\details{
The survival and density functions are given by
\deqn{S(x) = \exp\{-x / \sigma\} \qquad
      f(x) = \frac{1}{\sigma} \exp\{-x / \sigma\} \qquad (x > 0)}{
      S(x) = exp(-x / sigma)  f(x) = exp(-x / sigma) / sigma (x > 0)}
where \eqn{\sigma} is the scale parameter. This distribution is
the Generalized Pareto Distribution for a shape \eqn{\xi = 0}.

The probability functions \code{d}, \code{p} and \code{q}
    all allow the parameter \code{scale} to be a vector. Then the
    recycling rule is used to get two vectors of the same length,
    corresponding to the first argument and to the scale
    parameter. This behaviour is the standard one for the
    probability functions of the \strong{stats} package but is
    unusual in R packages devoted to Extreme Value in which the
    parameters must generally have length one. Note that the
    provided functions can be used e.g. to evaluate the quantile
    with a given probability for a large number of values of the
    parameter vector \code{shape}. This is frequently required in
    he Bayesian framework with MCMC inference.
}
\note{
The attributes \code{"gradient"} and \code{"hessian"} have
    dimension \code{c(n, 1)} and \code{c(n, 1, 1)}, even when
    \code{n} equals \code{1}. Use the \code{drop} method on these
    objects to drop the extra dimension if wanted i.e. to get a
    gradient vector and a Hessian matrix.
}
\examples{
## Illustrate the effect of recycling rule.
pexp1(1.0, scale = 1:4, lower.tail = FALSE) - exp(-1.0 / (1:4))
pexp1(1:4, scale = 1:4, lower.tail = FALSE) - exp(-1.0)

## With gradient and Hessian.
pexp1(c(1.1, 1.7), scale = 1, deriv = TRUE, hessian = TRUE)
}
\seealso{
The exponential distribution
    \code{\link[stats]{Exponential}} with \eqn{rate} being the
    inverse scale.
}
