% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCI.R
\name{GCI}
\alias{GCI}
\title{GCI - Green Chlorophyll Index}
\usage{
GCI(G, NIR)
}
\arguments{
\item{G}{A raster layer object with the reflectance values for the Green band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
GCI - Green Chlorophyll Index.
}
\description{
This function is used to estimate leaf chlorophyll content of plants species.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
GCI(x[[3]], x[[5]])

}
\references{
Gitelson et al., 2003. Relationships between leaf chlorophyll content and spectral reflectance and algorithms for non-destructive chlorophyll assessment in higher plant leaves. Journal of Plant Physiology, 160, 271-282.
}
