% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNP_distributions.R
\name{ChineseRestaurantProcess}
\alias{ChineseRestaurantProcess}
\alias{dCRP}
\alias{rCRP}
\title{The Chinese Restaurant Process Distribution}
\usage{
dCRP(x, conc = 1, size, log = 0)

rCRP(n, conc = 1, size)
}
\arguments{
\item{x}{vector of values.}

\item{conc}{scalar concentration parameter.}

\item{size}{integer-valued length of \code{x} (required).}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only n = 1 is handled currently).}
}
\value{
\code{dCRP} gives the density, and \code{rCRP} gives random generation.
}
\description{
Density and random generation for the Chinese
  Restaurant Process distribution.
}
\details{
The Chinese restaurant process distribution is a distribution
on the space of partitions of the positive integers. 
The distribution with concentration parameter \eqn{\alpha} equal to \code{conc} 
has probability function 
\deqn{
f(x_i \mid x_1, \ldots, x_{i-1})=\frac{1}{i-1+\alpha}\sum_{j=1}^{i-1}\delta_{x_j}+
\frac{\alpha}{i-1+\alpha}\delta_{x^{new}},}
where \eqn{x^{new}} is a new integer not in \eqn{x_1, \ldots, x_{i-1}}.

If \code{conc} is not specified, it assumes the default value of 1. The \code{conc} 
parameter has to be larger than zero. Otherwise, \code{NaN} are returned.
}
\examples{
x <- rCRP(n=1, conc = 1, size=10)
dCRP(x, conc = 1, size=10)
}
\author{
Claudia Wehrhahn
}
\references{
Blackwell, D., and MacQueen, J. B. (1973). Ferguson distributions via 
P\'{o}lya urn schemes. \emph{The Annals of Statistics}, 1: 353-355.

Aldous, D. J. (1985). Exchangeability and related topics. In \emph{\'{E}cole d'\'{E}t\'{e} 
de Probabilit\'{e}s de Saint-Flour XIII - 1983} (pp. 1-198). Springer, Berlin, 
Heidelberg.

Pitman, J. (1996). Some developments of the Blackwell-MacQueen urn scheme. \emph{IMS Lecture
Notes-Monograph Series}, 30: 245-267.
}

