% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAR.R
\name{as.carAdjacency}
\alias{as.carAdjacency}
\title{Convert CAR structural parameters to adjacency, weights, num format}
\usage{
as.carAdjacency(...)
}
\arguments{
\item{...}{Either: a symmetric matrix of unnormalized weights, or two lists specifying adjacency indices and the corresponding unnormalized weights.}
}
\description{
This will convert alternate representations of CAR process structure into
(adj, weights, num) form required by \code{dcar_normal}.
}
\details{
Two alternate representations are handled:

A single matrix argument will be interpreted as a matrix of symmetric unnormalized weights;

Two lists will be interpreted as (the first) a list of numeric vectors
specifying the adjacency (neighboring) indices of each CAR process component,
and (the second) a list of numeric vectors giving the unnormalized weights
for each of these neighboring relationships.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{CAR-Normal}}
}

