% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{LKJ}
\alias{LKJ}
\alias{lkj}
\alias{dlkj}
\alias{rlkj}
\alias{lkj_corr}
\alias{lkj_corr_cholesky}
\alias{dlkj_corr_cholesky}
\alias{rlkj_corr_cholesky}
\title{The LKJ Distribution for the Cholesky Factor of a Correlation Matrix}
\usage{
dlkj_corr_cholesky(x, eta, p, log = FALSE)

rlkj_corr_cholesky(n = 1, eta, p)
}
\arguments{
\item{x}{upper-triangular Cholesky factor of a correlation matrix.}

\item{eta}{shape parameter.}

\item{p}{size of the correlation matrix (number of rows and columns); required because random generation function has no information about dimension of matrix to generate without this argument.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{dlkj_corr_cholesky} gives the density and \code{rlkj_corr_cholesky} generates random deviates.
}
\description{
Density and random generation for the LKJ distribution for the Cholesky factor of a correlation matrix.
}
\details{
See Stan Development Team for mathematical details.
}
\examples{
eta <- 3
x <- rlkj_corr_cholesky(1, eta, 5)
dlkj_corr_cholesky(x, eta, 5)

}
\references{
Stan Development Team. Stan Reference Functions, version 2.27.
}
\seealso{
\code{\link{Distributions}} for other standard distributions
}
\author{
Christopher Paciorek
}
