% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLogExp.R
\name{dLogExp}
\alias{dLogExp}
\alias{rLogExp}
\title{Log transformed exponential distribution.}
\usage{
dLogExp(x, rate = 1, log = 0)

rLogExp(n = 1, rate = 1)
}
\arguments{
\item{x}{A continuous random variable on the real line. Let y=exp(x). Then y ~ dexp(rate).}

\item{rate}{Rate parameter of y ~ dexp(rate).}

\item{log}{Logical flag to toggle returning the log density.}

\item{n}{Number of random variables. Currently limited to 1, as is common in nimble. See ?replicate for an alternative.}
}
\value{
The density or log density of x, such that x = log(y) and y ~ dexp(rate).
}
\description{
\code{dLogExp} and \code{rLogExp} provide a log-transformed exponential distribution.
}
\examples{

## Create a exponential random variable, and transform it to the log scale
n      = 100000
lambda = 3
y      = rexp(n=n, rate=lambda)
x      = log(y)

## Plot histograms of the two random variables
oldpar <- par()
par(mfrow=n2mfrow(2))
## Plot 1
hist(x, n=100, freq=FALSE)
curve(dLogExp(x, rate=lambda), -15, 4, n=1001, col="red", add=TRUE, lwd=3)
## Plot 2: back-transformed
xNew = replicate(n=n, rLogExp(n=1, rate=lambda))
yNew   = exp(xNew)
hist(yNew, n=100, freq=FALSE, xlab="exp(x)")
curve(dexp(x, rate=lambda), 0, 4, n=1001, col="red", lwd=3, add=TRUE)
par(oldpar)

## Create a NIMBLE model that uses this distribution
code = nimbleCode({
  x ~ dLogExp(rate = 0.5)
  y <- exp(x)
})

\donttest{
## Build & compile the model
modelR = nimbleModel(code=code)
modelC = compileNimble(modelR)

## Configure, build and compile an MCMC
conf  = configureMCMC(modelC, monitors=c("x","y"))
mcmc  = buildMCMC(conf=conf)
cMcmc = compileNimble(mcmc)

## Run the MCMC
samps = runMCMC(mcmc=cMcmc, niter=50000)
x     = samps[,"x"]
y     = samps[,"y"]

## Plot MCMC output
oldpar <- par()
par(mfrow=n2mfrow(3))
## Plot 1: MCMC trajectory
plot(x, typ="l")
## Plot 2: taget density on unbounded sampling scale
hist(x, n=100, freq=FALSE)
curve(dLogExp(x, rate=0.5), -15, 5, n=1001, col="red", lwd=3, add=TRUE)
## Plot 3: taget density on bounded scale
hist(y, n=100, freq=FALSE)
curve(dexp(x, rate=0.5), 0, 25, n=1001, col="red", lwd=3, add=TRUE)
par(oldpar)
}
}
\author{
David R.J. Pleydell
}
