% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histNormal.R
\name{histNormal}
\alias{histNormal}
\title{Histogram with normal curve superimposed to help with “by-eye” assessments
of normality of distribution}
\usage{
histNormal(
  x,
  xlab = deparse(substitute(x)),
  ylab = "Frequency",
  main = deparse(substitute(x)),
  breaks = "Sturges",
  ylim = NULL
)
}
\arguments{
\item{x}{A numeric vector}

\item{xlab}{\code{x-axis} label}

\item{ylab}{\code{y-axis} label}

\item{main}{Plot title}

\item{breaks}{Passed to \code{\link[=hist]{hist()}} function (\code{?hist} for details)}

\item{ylim}{\code{y-axis} limits}
}
\description{
Histogram with normal curve superimposed to help with “by-eye” assessments
of normality of distribution
}
\examples{
# histNormal() with data from a SMART survey in Kabul, Afghanistan
# (dist.ex01)
svy <- dist.ex01
histNormal(svy$muac)
histNormal(svy$haz)
histNormal(svy$waz)
histNormal(svy$whz)

}
