% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digitPreference.R
\name{plot.digitPreference}
\alias{plot.digitPreference}
\title{\code{\link[=plot]{plot()}} helper function for \code{\link[=digitPreference]{digitPreference()}} function}
\usage{
\method{plot}{digitPreference}(x, main = "", xlab = "Final Digit", ylab = "Frequency", cex = 0.75, ...)
}
\arguments{
\item{x}{Object resulting from applying the \code{\link[=digitPreference]{digitPreference()}} function.}

\item{main}{Title of plot}

\item{xlab}{\code{x-axis} label; default is "Final Digit"}

\item{ylab}{\code{y-axis} label; default is "Frequency"}

\item{cex}{Character expansion; default is 0.75}

\item{...}{Additional \code{\link[=plot]{plot()}} parameters}
}
\value{
Plotted output of \code{\link[=digitPreference]{digitPreference()}} function comparing the
frequencies of the various final digits
}
\description{
\code{\link[=plot]{plot()}} helper function for \code{\link[=digitPreference]{digitPreference()}} function
}
\examples{
# Plot output of digit preference test applied to anthropometric data from a
# single state from a DHS survey in a West African country
svy <- dp.ex01
digitPreference(svy$wt, digits = 1)
plot(digitPreference(svy$wt, digits = 1))

}
