% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nixtla_data_prep.R
\name{.nixtla_data_prep}
\alias{.nixtla_data_prep}
\title{Prepares data for 'TimeGPT''s 'API'
This is a private function of 'nixtlar'}
\usage{
.nixtla_data_prep(df, freq, id_col, time_col, target_col)
}
\arguments{
\item{df}{A tsibble or a data frame with time series data.}

\item{freq}{Frequency of the data.}

\item{id_col}{Column that identifies each series. Should be named unique_id.}

\item{time_col}{Column that identifies each timestep. Should be named ds.}

\item{target_col}{Column that contains the target variable. Should be named y.}
}
\value{
A list with the given or inferred frequency, the prepared data, and the original data frame renamed.
}
\description{
Prepares data for 'TimeGPT''s 'API'
This is a private function of 'nixtlar'
}
\examples{
df <- nixtlar::electricity
data <- .nixtla_data_prep(df, freq="H")

}
\keyword{internal}
