% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{get_njtr1}
\alias{get_njtr1}
\title{Download New Jersey car accident records for a given year}
\usage{
get_njtr1(year, type, county = "all", geo = FALSE)
}
\arguments{
\item{year}{Year to download crash data for}

\item{type}{The table of NJDOT crash data to download}

\item{county}{Specify a specific county to download data for (default = all)}

\item{geo}{Logical, whether to filter only to geotagged cases (default = FALSE)}
}
\value{
data.frame of all reported accidents for the year
}
\description{
Download New Jersey car accident records for a given year
}
\examples{
get_njtr1(year = 2019, type = "Pedestrians")
}
