% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-mcmc-list.R
\name{as_mcmc_list}
\alias{as_mcmc_list}
\alias{as_mcmc_list.mcmc}
\alias{as_mcmc_list.nlist}
\alias{as_mcmc_list.nlists}
\title{Coerce to an mcmc.list Object}
\usage{
as_mcmc_list(x, ...)

\method{as_mcmc_list}{mcmc}(x, ...)

\method{as_mcmc_list}{nlist}(x, ...)

\method{as_mcmc_list}{nlists}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Unused.}
}
\value{
An mcmc.list object.
}
\description{
Coerce an R object to an mcmc.list object.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcmc}: Coerce an mcmc object to an mcmc.list object.

\item \code{nlist}: Coerce an nlist object to an mcmc.list object.

\item \code{nlists}: Coerce an nlists object to an mcmc.list object.
}}

\examples{
as_mcmc_list(nlist(x = matrix(1:6, 2)))

as_mcmc_list(nlists(
  nlist(x = matrix(1:6, 2)),
  nlist(x = matrix(3:8, 2))
))
}
\seealso{
Other mcmc: 
\code{\link{as_mcmc}()}
}
\concept{mcmc}
