### $Id: Glucose.R,v 1.3 2000/07/03 18:22:44 bates Exp $
### Data on the glucose levels of several subjects over time under different
###  conditions of taking meals.
### Hand and Crowder (1996), Table B.12, p. 199-200.
"Glucose" <-
  structure(list(
   Subject = structure(ordered(c(5, 5, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6, 6, 6, 6, 6, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), levels=1:6),
     class = c("ordered", "factor"),
     .Label = c("6", "2", "3", "5", "1", "4")),
   Time = c(-0.25, 
     0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 
     5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 
     1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 
     7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 
     1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 
     0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 
     4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 
     1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 
     6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 
     2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 
     0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 
     4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 
     1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 
     7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 
     2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 
     0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 
     5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 
     1, 1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 
     7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 
     1.5, 2, 3, 4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, -0.25, 
     0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 1, 1.5, 2, 3, 
     4, 5, 6, -0.25, 0, 0.5, 1, 1.5, 2, 3, 4, 5, 6, 7, -0.25, 0, 0.5, 
     1, 1.5, 2, 3, 4, 5, 6, 7),
   conc = c(4.9, 4.5, 7.84, 5.46, 5.08, 
     4.32, 3.91, 3.99, 4.15, 4.41, 4.91, 4.18, 9, 9.74, 6.95, 6.92, 
     4.66, 3.45, 4.2, 4.63, 4.22, 4.92, 8.09, 6.74, 4.3, 4.28, 4.59, 
     4.49, 5.29, 4.95, 4.34, 4.05, 3.78, 8.71, 7.12, 6.17, 4.22, 4.31, 
     3.15, 3.64, 3.88, 5.03, 4.99, 9.1, 10.03, 9.2, 8.31, 7.92, 4.86, 
     4.63, 3.52, 4.17, 4.6, 4.72, 9.53, 10.02, 10.25, 9.29, 5.45, 
     4.82, 4.09, 3.52, 3.92, 4.61, 4.65, 7.9, 6.13, 4.45, 4.17, 4.96, 
     4.36, 4.26, 4.13, 4.16, 3.42, 7.09, 6.98, 6.13, 5.36, 6.13, 3.67, 
     4.37, 4.31, 4.52, 4.22, 8.46, 9.12, 7.5, 6.02, 4.66, 4.69, 4.26, 
     4.29, 4.47, 3.94, 4.14, 7.82, 8.68, 6.22, 5.1, 5.16, 4.38, 4.22, 
     4.27, 4.51, 4.5, 8.74, 8.8, 7.1, 8.2, 7.42, 5.79, 4.85, 4.94, 
     2.07, 4.33, 4.1, 4.36, 6.92, 9.06, 8.11, 5.69, 5.91, 5.65, 4.58, 
     3.79, 5.37, 5.35, 7.94, 5.64, 5.06, 5.49, 4.77, 4.48, 4.39, 4.45, 
     4.95, 4.4, 7, 7.8, 7.78, 7.3, 5.82, 5.14, 3.59, 4, 4.47, 4.47, 
     7.95, 7.21, 6.35, 5.58, 4.57, 3.9, 3.44, 4.18, 4.32, 4.19, 4.22, 
     7.45, 8.07, 6.84, 6.86, 4.79, 3.87, 3.6, 4.92, 4.87, 5.12, 6.32, 
     9.48, 9.88, 6.28, 5.58, 5.26, 4.1, 4.25, 4.55, 4.42, 4.07, 5.48, 
     9.05, 8.04, 7.19, 4.87, 5.4, 4.35, 4.51, 4.66, 5.1, 5.22, 7.2, 
     4.95, 4.45, 3.88, 3.65, 4.21, NA, 4.44, 3.82, 4, 6.56, 6.48, 
     5.66, 7.74, 4.45, 4.07, 3.73, 3.58, 4.27, 4.33, 6.61, 6.89, 5.64, 
     4.85, 4.82, 3.82, 4.31, 3.81, 2.92, 4.31, 4.45, 7.34, 6.75, 7.55, 
     6.42, 5.75, 4.56, 4.3, 3.92, 4.55, 4.44, 5.56, 8.39, 7.85, 7.4, 
     6.23, 4.59, 4.31, 3.96, 4.05, 4.38, 4.54, 8.86, 10.01, 10.47, 
     9.91, 6.11, 4.37, 3.38, 4.02, 3.84, 5.34, 4.91, 5.69, 8.21, 2.97, 
     4.3, 4.18, 4.93, 5.16, 5.54, 3.76, 4.7, 6.76, 4.98, 5.02, 5.95, 
     4.9, 4.79, 5.25, 5.42, 4.81, 4.85, 6.08, 8.28, 5.73, 5.68, 4.66, 
     4.62, 4.85, 4.69, 4.86, 4.3, 4.71, 7.44, 7.08, 6.3, 6.5, 4.5, 
     4.36, 4.83, 4.5, 4.79, 4.82, 9.29, 8.99, 8.15, 5.71, 5.24, 4.95, 
     5.06, 5.24, 4.74, 5.06, 5.04, 8.86, 9.97, 8.45, 6.58, 4.74, 4.28, 
     4.04, 4.34, 4.35, 5.24, 5.04, 8.72, 4.85, 5.57, 6.33, 4.81, 4.55, 
     4.48, 5.15, 4.13, 3.95, 5.53, 8.55, 7.09, 5.34, 5.56, 4.23, 3.95, 
     4.29, 4.61, 4.68, 6.01, 7.35, 6.38, 6.16, 4.41, 4.96, 4.33, 4.54, 
     4.81, 4.45, 4.12, 7.14, 5.68, 6.07, 5.96, 5.2, 4.83, 4.5, 4.71, 
     4.33, 4.48, 8.06, 8.49, 4.5, 7.15, 5.91, 4.27, 4.78, NA, 5.72, 
     4.43, 4.75, 6.95, 6.64, 7.72, 7.03, 6.38, 5.17, 4.71, 5.14, 5.19
     ),
   Meal = structure(factor(c(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6), levels=1:6),
     class = c("ordered", "factor"),
     .Label = c("2am", "6am", "10am", "2pm", "6pm", "10pm"))),
row.names = as.character(1:378),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = conc ~ Time | Subject,
labels = list(x = "Time from beginning of meal",
  y = "Serum concentration of Glucose"),
units = list(x = "(hr)", y = "(mg/dl)"), inner = ~ Meal)
