### $Id: PBG.R,v 1.3 2000/07/03 18:22:45 bates Exp $
### Change in blood pressure versus dose of phenylbiguanide for several rabbits
### Ludbrook (1994), Cardiovascular Research, 28, 303-311.
### Also cited in Venables and Ripley (1997)
"PBG" <-
  structure(list
  (deltaBP = c(0.5, 4.5, 10, 26, 37, 32, 1, 1.25, 
     4, 12, 27, 29, 0.75, 3, 3, 14, 22, 24, 1.25, 1.5, 6, 19, 33, 
     33, 1.5, 1.5, 5, 16, 20, 18, 1.25, 0.75, 4, 9, 25, 37, 1.4, 1.7, 
     1, 2, 15, 28, 0.75, 2.3, 3, 5, 26, 25, 2.6, 1.2, 2, 3, 11, 22, 
     2.4, 2.5, 1.5, 2, 9, 19),
   dose = c(6.25, 12.5, 25, 50, 100, 200, 
     6.25, 12.5, 25, 50, 100, 200, 6.25, 12.5, 25, 50, 100, 200, 6.25, 
     12.5, 25, 50, 100, 200, 6.25, 12.5, 25, 50, 100, 200, 6.25, 12.5, 
     25, 50, 100, 200, 6.25, 12.5, 25, 50, 100, 200, 6.25, 12.5, 25, 
     50, 100, 200, 6.25, 12.5, 25, 50, 100, 200, 6.25, 12.5, 25, 50, 
     100, 200),
   Run = structure(factor(c(10, 10, 10, 10, 10, 10, 8, 
     8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 6, 6, 6, 6, 
     6, 6, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 2, 
     2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1), levels=1:10),
     class = c("ordered", "factor"),
     .Label = c("T5", "T4", "T3", "T2", "T1", "P5", "P3", "P2", "P4", "P1")),
   Treatment = structure(factor(c(2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), levels=1:2),
     class = "factor",
     .Label = c("MDL 72222", "Placebo")),
   Rabbit = structure(ordered(c(5, 5, 5, 5, 5, 5, 3, 
     3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 
     1, 1, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 4, 
     4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1), levels=1:5),
     class = c("ordered", "factor"),
     .Label = c("5", "3", "2", "4", "1"))),
row.names = 1:60,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = deltaBP ~ dose | Rabbit,
labels = list(x = "Dose of phenylbiguanide",
  y = "Change in blood pressure"),
units = list(x = "(ug)", y = "(mm Hg)"),
inner = ~Treatment)
