### $Id: Fatigue.R,v 1.1 2000/03/17 22:21:21 saikat Exp $
### Data on the crack propagation in metal fatigue
### Given in Lu and Meeker (1993), Technometrics, 35, 161-174
### Derived from a figure in Bogdanoff and Kozin (1985).
"Fatigue" <-
  structure(list(
   Path = structure(ordered(c(1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 
     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 
     10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 
     11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
     12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
     14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 
     16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
     17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
     18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 
     21, 21, 21, 21, 21, 21, 21, 21), levels=1:21),
     class = c("ordered", "factor"),
     .Label = c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
       "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21")),
   cycles = c(0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 
     0.07, 0.08, 0.09, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 
     0.08, 0.09, 0.1, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 
     0.08, 0.09, 0.1, 0.11, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 
     0.07, 0.08, 0.09, 0.1, 0.11, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 
     0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0, 0.01, 0.02, 0.03, 0.04, 
     0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0, 0.01, 0.02, 0.03, 
     0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0, 0.01, 0.02, 
     0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0, 0.01, 
     0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 
     0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 
     0.11, 0.12, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 
     0.09, 0.1, 0.11, 0.12, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 
     0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0, 0.01, 0.02, 0.03, 0.04, 
     0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0, 0.01, 0.02, 
     0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0, 
     0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 
     0.12, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 
     0.1, 0.11, 0.12, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 
     0.08, 0.09, 0.1, 0.11, 0.12, 0, 0.01, 0.02, 0.03, 0.04, 0.05, 
     0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0, 0.01, 0.02, 0.03, 
     0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0, 0.01, 
     0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 
     0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 
     0.11, 0.12),
   relLength = c(1, 1.055556, 1.111111, 1.166667, 1.244444, 
     1.322222, 1.411111, 1.5, 1.644444, 1.822222, 1, 1.044444, 1.088889, 
     1.144444, 1.2, 1.266667, 1.344444, 1.422222, 1.522222, 1.633333, 
     1.777778, 1, 1.044444, 1.088889, 1.144444, 1.2, 1.255556, 1.322222, 
     1.4, 1.5, 1.622222, 1.755556, 1.966667, 1, 1.044444, 1.088889, 
     1.144444, 1.188889, 1.244444, 1.322222, 1.388889, 1.488889, 1.588889, 
     1.722222, 1.922222, 1, 1.044444, 1.088889, 1.144444, 1.188889, 
     1.244444, 1.322222, 1.377778, 1.488889, 1.588889, 1.722222, 1.9, 
     1, 1.044444, 1.088889, 1.144444, 1.188889, 1.244444, 1.311111, 
     1.366667, 1.477778, 1.566667, 1.677778, 1.866667, 1, 1.044444, 
     1.088889, 1.133333, 1.188889, 1.233333, 1.3, 1.366667, 1.466667, 
     1.566667, 1.688889, 1.844444, 1, 1.033333, 1.077778, 1.111111, 
     1.177778, 1.233333, 1.3, 1.366667, 1.444444, 1.544444, 1.655556, 
     1.8, 1, 1.022222, 1.077778, 1.122222, 1.166667, 1.211111, 1.277778, 
     1.344444, 1.422222, 1.511111, 1.6, 1.722222, 1.911111, 1, 1.022222, 
     1.066667, 1.111111, 1.155556, 1.2, 1.255556, 1.322222, 1.4, 1.488889, 
     1.577778, 1.688889, 1.855556, 1, 1.033333, 1.066667, 1.111111, 
     1.155556, 1.2, 1.255556, 1.311111, 1.377778, 1.455556, 1.544444, 
     1.655556, 1.833333, 1, 1.033333, 1.077778, 1.111111, 1.144444, 
     1.188889, 1.222222, 1.288889, 1.355556, 1.433333, 1.522222, 1.644444, 
     1.822222, 1, 1.022222, 1.077778, 1.1, 1.144444, 1.177778, 1.222222, 
     1.266667, 1.333333, 1.4, 1.455556, 1.555556, 1.688889, 1, 1.033333, 
     1.066667, 1.111111, 1.144444, 1.188889, 1.244444, 1.288889, 1.333333, 
     1.4, 1.444444, 1.522222, 1.611111, 1, 1.022222, 1.066667, 1.1, 
     1.144444, 1.177778, 1.222222, 1.288889, 1.344444, 1.411111, 1.477778, 
     1.555556, 1.655556, 1, 1.022222, 1.055556, 1.077778, 1.111111, 
     1.144444, 1.188889, 1.233333, 1.288889, 1.355556, 1.4, 1.477778, 
     1.555556, 1, 1.033333, 1.066667, 1.077778, 1.111111, 1.166667, 
     1.2, 1.233333, 1.288889, 1.333333, 1.377778, 1.466667, 1.533333, 
     1, 1.022222, 1.044444, 1.077778, 1.122222, 1.155556, 1.188889, 
     1.211111, 1.266667, 1.322222, 1.366667, 1.422222, 1.5, 1, 1.022222, 
     1.044444, 1.077778, 1.1, 1.133333, 1.166667, 1.2, 1.244444, 1.288889, 
     1.333333, 1.388889, 1.455556, 1, 1.022222, 1.044444, 1.077778, 
     1.1, 1.133333, 1.166667, 1.2, 1.244444, 1.288889, 1.322222, 1.377778, 
     1.433333, 1, 1.022222, 1.044444, 1.077778, 1.1, 1.133333, 1.155556, 
     1.188889, 1.233333, 1.266667, 1.311111, 1.355556, 1.411111)),
row.names = 1:262,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = relLength ~ cycles | Path,
labels = list(x = "Stress", y = "Relative crack length"),
units = list(x = "(millions of cycles)"))
