### $Id: RatPupWeight.R,v 1.1 2000/03/17 22:21:21 saikat Exp $
### Weight of rat pups by litter where the dam is treated with a drug
### Dempster et al. (1984).  Cited in Davidian and Giltinan (1995),
### section 3.2.1, p. 64-65.
"RatPupWeight" <-
  structure(list(
  weight = c(6.6, 7.4, 7.15, 7.24, 7.1, 6.04, 6.98, 
    7.05, 6.95, 6.29, 6.77, 6.57, 6.37, 6.37, 6.9, 6.34, 6.5, 6.1, 
    6.44, 6.94, 6.41, 5.92, 6.04, 5.82, 6.04, 5.96, 7.5, 7.08, 7.57, 
    7.27, 6.25, 6.93, 6.8, 6.69, 6.28, 6.27, 6.27, 6.47, 6.29, 5.98, 
    6.32, 6.28, 5.65, 5.57, 7.96, 6.84, 7, 8.1, 6.52, 7.23, 6.1, 
    7.31, 7.16, 7.09, 7.14, 5.02, 6.04, 8.26, 7.73, 8.33, 6.14, 7.75, 
    6.96, 7.26, 6.58, 3.68, 6.29, 6.32, 6.28, 6.24, 6.78, 6.63, 6.27, 
    6.29, 6.06, 6.16, 5.96, 6.26, 5.83, 6.11, 6.45, 6.25, 6.31, 5.74, 
    6.04, 5.84, 6.77, 5.59, 5.52, 6.42, 5.97, 6.34, 6.23, 5.95, 6.16, 
    6.19, 5.32, 5, 6.3, 5, 5.56, 5.37, 5.58, 5.51, 5.19, 5.34, 5.77, 
    5.17, 4.57, 5.39, 5.62, 5.4, 5.77, 5.24, 5.37, 5.33, 5.44, 5.14, 
    7.3, 6.6, 6.58, 6.68, 6.46, 6.38, 6.44, 6.67, 6.43, 6.53, 5.92, 
    6.52, 6.44, 5.65, 5.78, 6.23, 5.7, 5.73, 6.1, 5.55, 5.71, 5.81, 
    6.1, 5.54, 5.72, 5.5, 5.64, 5.42, 5.42, 6.89, 7.73, 5.83, 5.97, 
    6.39, 5.69, 5.69, 5.97, 6.04, 5.46, 6.09, 5.39, 5.89, 5.14, 5.92, 
    5.75, 6.22, 5.96, 5.59, 5.79, 6.23, 5.88, 6.02, 5.66, 5.76, 5.73, 
    5.33, 5.58, 5.88, 6, 6.11, 6.4, 6.06, 6.39, 6.09, 6.32, 5.96, 
    6.32, 5.83, 5.97, 5.87, 5.67, 6.43, 6.13, 5.87, 6.09, 5.63, 5.84, 
    6.2, 6.42, 5.9, 5.62, 6.23, 5.85, 5.89, 5.81, 5.44, 5.65, 5.25, 
    5.45, 5.32, 5.89, 5.63, 5.12, 5.65, 5.29, 5.13, 5.6, 5.08, 6.77, 
    7.13, 6.85, 6.49, 6.09, 6.09, 5.99, 6.01, 6.11, 6.15, 4.75, 5.69, 
    6.19, 5.72, 6.14, 6.72, 6.34, 6.48, 5.74, 6.11, 5.71, 6.41, 6.21, 
    6.11, 5.81, 5.9, 6.22, 6.67, 6.23, 6.24, 6.26, 6.38, 6.05, 5.89, 
    6.29, 6.12, 5.4, 5.5, 5.46, 5.97, 6.11, 5.09, 5.57, 5.69, 5.5, 
    5.45, 5.24, 5.36, 5.26, 5.36, 5.01, 5.03, 5.23, 5.13, 4.48, 5.3, 
    5.4, 5.55, 6.02, 5.27, 5.19, 5.42, 5.4, 5.12, 5.4, 7.7, 7.68, 
    6.33, 6.28, 5.74, 6.29, 5.68, 5.76, 6.03, 5.3, 5.55, 6.53, 5.76, 
    5.77, 5.49, 6.5, 7.1, 7, 7, 5.85, 6.1, 6.63, 6.33, 7, 6.15, 6.22, 
    6.2, 5.76, 6.21, 6.42, 6.42, 6.3, 5.64, 6.06, 6.56, 6.29, 5.69, 
    6.36, 5.93, 5.74, 5.74),
sex = structure(factor(c(1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
  2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
  2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 
  2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 
  1, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 
  2, 2, 2), levels=1:2), class = "factor",
  .Label = c("Male", "Female")),
Litter = structure(ordered(c(7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 8, 8, 8, 8, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 27, 
  27, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 
  26, 26, 26, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 17, 17, 17, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14),
  levels=1:27), class = c("ordered", "factor"),
  .Label = structure(c("9", "8", "7", "4", "2", "10", 
    "1", "3", "5", "6", "21", "22", "24", "27", "26", "25", "23", 
    "17", "11", "14", "13", "15", "16", "20", "19", "18", "12"),
    .Names = c("Control1", 
      "Control2", "Control3", "Control4", "Control5", "Control6", "Control7", 
      "Control8", "Control9", "Control10", "High1", "High2", "High3", 
      "High4", "High5", "High6", "High7", "Low1", "Low2", "Low3", "Low4", 
      "Low5", "Low6", "Low7", "Low8", "Low9", "Low10"))),
Lsize = c(12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 4, 4, 4, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 9, 9, 9, 9, 9, 9, 9, 9, 9, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 2, 
  2, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 3, 3, 3, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9),
Treatment = structure(ordered(c(1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3), levels=1:3), class = c("ordered", "factor"),
  .Label = c("Control", "Low", "High"))),
row.names = 1:322,
class = c("nffGroupedData", "nfGroupedData", "groupedData", "data.frame"),
outer = ~Treatment,
formula = weight ~ 1 | Litter,
labels = list(y = "Weight of rat pup"),
units = list(y = "(g)"),
inner = ~ sex,
FUN = function (x) max(x, na.rm = TRUE),
order.groups = TRUE)
