% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_fit.R
\name{nlme_lin_cmpt}
\alias{nlme_lin_cmpt}
\alias{nlmeLinCmpt}
\alias{nlmeLinCmt}
\title{Fit nlme-based linear compartment mixed-effect model using closed form solution}
\usage{
nlme_lin_cmpt(dat, parModel, ncmt, oral = TRUE, infusion = FALSE,
  tlag = FALSE, parameterization = 1, parTrans = .getParfn(oral, ncmt,
  parameterization, tlag), mcCores = 1, ...)

nlmeLinCmpt(dat, parModel, ncmt, oral = TRUE, infusion = FALSE,
  tlag = FALSE, parameterization = 1, parTrans = .getParfn(oral, ncmt,
  parameterization, tlag), mcCores = 1, ...)

nlmeLinCmt(dat, parModel, ncmt, oral = TRUE, infusion = FALSE,
  tlag = FALSE, parameterization = 1, parTrans = .getParfn(oral, ncmt,
  parameterization, tlag), mcCores = 1, ...)
}
\arguments{
\item{dat}{data to be fitted}

\item{parModel}{list: model for fixed effects, randoms effects and initial values using nlme-type syntax.}

\item{ncmt}{numerical: number of compartments: 1-3}

\item{oral}{logical}

\item{infusion}{logical}

\item{tlag}{logical}

\item{parameterization}{numerical: type of parameterization, 1=clearance/volume, 2=micro-constants}

\item{parTrans}{function: calculation of PK parameters}

\item{mcCores}{number of cores used in fitting (only for Linux)}

\item{...}{additional nlme options}
}
\description{
'nlme_lin_cmpt' fits a linear one to three compartment model with
either first order absorption, or i.v. bolus, or i.v. infusion.  A
user specifies the number of compartments, route of drug
administrations, and the model parameterization. `nlmixr` supports
the clearance/volume parameterization and the micro constant
parameterization, with the former as the default.  Specification of
fixed effects, random effects and intial values follows the standard
nlme notations.
}
\examples{
library(nlmixr)

specs <- list(fixed=lKA+lCL+lV~1, random = pdDiag(lKA+lCL~1), start=c(lKA=0.5, lCL=-3.2, lV=-1))
fit <- nlme_lin_cmpt(theo_md, par_model=specs, ncmt=1, verbose=TRUE)
#plot(augPred(fit,level=0:1))
summary(fit)

}
\author{
Wenping Wang
}
