% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.R
\name{frwd_selection}
\alias{frwd_selection}
\title{Forward covariate selection for nlme-base non-linear mixed effect models}
\usage{
frwd_selection(base, cv, dat, cutoff = 0.05)
}
\arguments{
\item{base}{base model}

\item{cv}{a list of candidate covariate to model parameters}

\item{dat}{model data}

\item{cutoff}{significance level}
}
\value{
an nlme object of the final model
}
\description{
Implements forward covariate selection for nlme-based non-linear mixed effect models
}
\examples{
dat <- theo_md
dat$LOGWT <- log(dat$WT)
dat$TG <- (dat$ID < 6) + 0    #dummy covariate

specs <- list(
	fixed=list(lKA=lKA~1, lCL=lCL~1, lV=lV~1),
	random = pdDiag(lKA+lCL~1),
	start=c(0.5, -3.2, -1))
fit0 <- nlme_lin_cmpt(dat, par_model=specs, ncmt=1)
cv <- list(lCL=c("WT", "TG"), lV=c("WT"))
fit <- frwd_selection(fit0, cv, dat)
print(summary(fit))
}
