% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynmodel.R
\name{dynmodel}
\alias{dynmodel}
\title{Fit a non-population dynamic model}
\usage{
dynmodel(
  system,
  model,
  inits,
  data,
  fixPars = NULL,
  nlmixrObject = NULL,
  control = list(),
  ...
)
}
\arguments{
\item{system}{RxODE object. See \code{\link[RxODE]{RxODE}} for more details.}

\item{model}{Error model.}

\item{inits}{Initial values of system parameters.}

\item{data}{Dataset to estimate. Needs to be RxODE compatible in EVIDs.}

\item{fixPars}{Fixed system parameters. Default is NULL.}

\item{nlmixrObject}{nlmixr object. See \code{\link[nlmixr]{nlmixr}} for more
details. Default is NULL.}

\item{control}{Control options for dynmodel
\code{\link[nlmixr]{dynmodelControl}} .}

\item{...}{Other parameters (ignored)}
}
\value{
A dynmodel fit object
}
\description{
Fit a non-population dynamic model
}
\examples{

\donttest{

# dynmodel example --------------------------------------------------------
ode <- "
      kel = CL/V;
      d/dt(X) = -kel*X;
      C=X/V;
      PRED = C
      "
ode_system <- RxODE(model = ode)
model_error_structure <- cp ~ C + add(0.01) + prop(0.01)
inits <- c(CL = 1, V = 10)
control <- dynmodelControl(method = "Nelder-Mead")
fit <-
  try(dynmodel(
    system = ode_system,
    model = model_error_structure,
    data = Bolus_1CPT,
    inits = inits,
    control = control
  ))

# nlmixr model example ----------------------------------------------------------
model_onecmt_bolus <- function() {
  ini({
    CL <- c(0, 5, 10) # Clearance (L/hr)
    V <- c(0, 50, 100) # Volume of Distribution
    prop.err <- c(0, 0.01, 1)
  })
  model({
    kel <- CL / V
    d / dt(X) <- -kel * X
    cp <- X / V
    cp ~ prop(prop.err)
  })
}

# note on some platforms this fit is not successful
fit <- try(nlmixr(object = model_onecmt_bolus, data = Bolus_1CPT, est = "dynmodel"))

if (inherits(fit, "nlmixrDynmodel")) {
 as.dynmodel(fit)
}

# method = "focei" is slightly more flexible and well tested

fit <- try(nlmixr(object = model_onecmt_bolus, data = Bolus_1CPT, est = "focei"))

}
}
\author{
Wenping Wang, Mason McComb and Matt Fidler
}
