% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precondition.R
\name{preconditionFit}
\alias{preconditionFit}
\title{Linearly re-parameterize the model to be less sensitive to rounding errors}
\usage{
preconditionFit(fit, estType = c("full", "posthoc", "none"), ntry = 10L)
}
\arguments{
\item{fit}{A nlmixr fit to be preconditioned}

\item{estType}{Once the fit has been linearly reparametrized,
should a "full" estimation, "posthoc" estimation or simply a
estimation of the covariance matrix "none" before the fit is
updated}

\item{ntry}{number of tries before giving up on a pre-conditioned
covariance estimate}
}
\value{
A nlmixr fit object that was preconditioned to stabilize
  the variance/covariance calculation
}
\description{
Linearly re-parameterize the model to be less sensitive to rounding errors
}
\references{
Aoki Y, Nordgren R, Hooker AC. Preconditioning of
  Nonlinear Mixed Effects Models for Stabilisation of
  Variance-Covariance Matrix Computations. AAPS
  J. 2016;18(2):505-518. doi:10.1208/s12248-016-9866-5
}
