% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynmodel.R
\name{dynmodel.mcmc}
\alias{dynmodel.mcmc}
\title{Fit a non-population dynamic model using mcmc}
\usage{
dynmodel.mcmc(
  system,
  model,
  evTable,
  inits,
  data,
  fixPars = NULL,
  nsim = 500,
  squared = TRUE,
  seed = NULL
)
}
\arguments{
\item{system}{an RxODE object}

\item{model}{a list of statistical measurement models}

\item{evTable}{an Event Table object}

\item{inits}{initial values of system parameters}

\item{data}{input data}

\item{fixPars}{fixed system parameters}

\item{nsim}{number of mcmc iterations}

\item{squared}{if parameters be squared during estimation}

\item{seed}{random number seed}
}
\value{
A dyn.mcmc object detailing the model fit
}
\description{
Fit a non-population dynamic model using mcmc
}
\examples{
\donttest{

ode <- "
   dose=200;
   pi = 3.1415926535897931;

   if (t<=0) {
      fI = 0;
   } else {
      fI = F*dose*sqrt(MIT/(2.0*pi*CVI2*t^3))*exp(-(t-MIT)^2/(2.0*CVI2*MIT*t));
   }

   C2 = centr/V2;
   C3 = peri/V3;
   d/dt(centr) = fI - CL*C2 - Q*C2 + Q*C3;
   d/dt(peri)  =              Q*C2 - Q*C3;
"
sys1 <- RxODE(model = ode)


## ------------------------------------------------------------------------
dat <- invgaussian
mod <- cp ~ C2 + prop(.1)
inits <- c(MIT = 190, CVI2 = .65, F = .92)
fixPars <- c(CL = .0793, V2 = .64, Q = .292, V3 = 9.63)
ev <- eventTable()
ev$add.sampling(c(0, dat$time))
(fit <- dynmodel.mcmc(sys1, mod, ev, inits, dat, fixPars))
}
}
\author{
Wenping Wang
}
