% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardReexports.R
\name{vpcPlotTad}
\alias{vpcPlotTad}
\title{VPC based on ui model}
\usage{
vpcPlotTad(..., idv = "tad")
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[nlmixr2plot:vpcPlot]{nlmixr2plot::vpcPlotTad()}}.}

\item{idv}{Name of independent variable. For \code{vpcPlot()} and
\code{vpcCens()} the default is \code{"time"} for \code{vpcPlotTad()} and
\code{vpcCensTad()} this is \code{"tad"}}
}
\value{
Simulated dataset (invisibly)
}
\description{
VPC based on ui model
}
\examples{
\donttest{
one.cmt <- function() {
 ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Log Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

fit <- nlmixr2est::nlmixr(one.cmt, nlmixr2data::theo_sd, est="focei")

vpcPlot(fit)

}
}
\author{
Matthew L. Fidler
}
