% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardReexports.R
\name{vpcCensTad}
\alias{vpcCensTad}
\title{VPC based on ui model}
\usage{
vpcCensTad(..., cens = TRUE, idv = "tad")
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[nlmixr2plot:vpcPlot]{nlmixr2plot::vpcCensTad()}}.}

\item{cens}{is a boolean to show if this is a censoring plot or
not.  When \code{cens=TRUE} this is actually a censoring vpc plot
(with \code{vpcCens()} and \code{vpcCensTad()}).  When \code{cens=FALSE} this is
traditional VPC plot (\code{vpcPlot()} and \code{vpcPlotTad()}).}

\item{idv}{Name of independent variable. For \code{vpcPlot()} and
\code{vpcCens()} the default is \code{"time"} for \code{vpcPlotTad()} and
\code{vpcCensTad()} this is \code{"tad"}}
}
\value{
Simulated dataset (invisibly)
}
\description{
VPC based on ui model
}
\examples{
\donttest{
one.cmt <- function() {
 ini({
   tka <- 0.45; label("Ka")
   tcl <- log(c(0, 2.7, 100)); label("Cl")
   tv <- 3.45; label("V")
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7; label("Additive residual error")
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

fit <-
  nlmixr2est::nlmixr(
    one.cmt,
    data = nlmixr2data::theo_sd,
    est = "saem",
    control = list(print = 0)
  )

vpcPlot(fit)
}
}
\author{
Matthew L. Fidler
}
