% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{llpControl}
\alias{llpControl}
\title{Control options for log-likelihood profiling}
\usage{
llpControl(
  ofvIncrease = qchisq(0.95, df = 1),
  rseTheta = 30,
  itermax = 10,
  ofvtol = 0.005,
  paramDigits = 3,
  extrapolateExpand = 1.5
)
}
\arguments{
\item{ofvIncrease}{The targetted change in objective function value (3.84
corresponds to a Chi-squared test with a 95\% confidence interval)}

\item{rseTheta}{The relative standard error (percent) for the model
parameters.  It can be missing (the default) in which case a default value
of 30\% will be applied.  If given as a single number, it will be applied to
all parameters.  If given as a named vector of numbers, it will be applied
to each named parameter.}

\item{itermax}{Maximum number of likelihood profiling iterations for each
bound estimated}

\item{ofvtol}{The relative tolerance for the objective function being close
enough to the \code{ofvIncrease}.}

\item{paramDigits}{The number of significant digits required for the
parameter.  When interpolation attempts to get smaller than that number of
significant digits, it will stop.}

\item{extrapolateExpand}{When extrapolating outside the range previously
tested, how far should the step occur as a ratio}
}
\value{
A validated list of control options for log-likelihood profiling
}
\description{
Control options for log-likelihood profiling
}
\seealso{
\code{\link[=profileLlp]{profileLlp()}}

Other Profiling: 
\code{\link{fixedControl}()},
\code{\link{profile.nlmixr2FitCore}()},
\code{\link{profileFixed}()},
\code{\link{profileLlp}()},
\code{\link{profileNlmixr2FitCoreRet}()}
}
\concept{Profiling}
