% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitFig.helper.R
\name{getFitFig}
\alias{getFitFig}
\title{Helper Function to Generate Visualization for a Fitted Model}
\usage{
getFitFig(
  model,
  nClass,
  cluster_TIC,
  grp_var,
  sub_Model,
  t_var,
  records,
  y_var,
  curveFun,
  y_model,
  xstarts,
  xlab,
  outcome
)
}
\arguments{
\item{model}{A fitted mxModel object. This is the output from one of the estimation functions in this package.
It takes value passed from \code{getFigure()}.}

\item{nClass}{An integer specifying the number of classes for the mixture model or multiple group model. It
takes value passed from \code{getFigure()}.}

\item{cluster_TIC}{A string or character vector representing the column name(s) for time-invariant covariate(s)
indicating cluster formations. It takes value passed from \code{getFigure()}.}

\item{grp_var}{A string specifying the column that indicates manifested classes when applicable. It takes the value
passed from \code{getFigure()}.}

\item{sub_Model}{A string that specifies the sub-model for latent classes. Supported sub-models include \code{"LGCM"} (for latent
growth curve models), \code{"LCSM"} (for latent change score models), \code{"TVC"} (for latent growth curve models or latent change
score models with a time-varying covariate), \code{"MGM"} (for multivariate latent growth curve models or latent change score models),
and \code{"MED"} (for longitudinal mediation models). It takes value passed from \code{getFigure()}.}

\item{t_var}{A string representing the prefix of the column names corresponding to the time variable at each study
wave. It takes value passed from \code{getFigure()}.}

\item{records}{A numeric vector representing the indices of the study waves. It takes value passed from \code{getFigure()}.}

\item{y_var}{A string or character vector representing the prefix of the column names for the outcome variable(s)
at each study wave. It takes value passed from \code{getFigure()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model = "LGCM"} include:
\code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported options for
\code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}),
\code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes value passed from \code{getFigure()}.}

\item{y_model}{A string that specifies how to fit longitudinal outcomes. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes value passed from \code{getFigure()}.}

\item{xstarts}{A numeric value to indicate the starting time of the longitudinal process. It takes value passed from \code{getFigure()}.}

\item{xlab}{A string representing the time unit (e.g., "Week", "Month", or "Year") for the x-axis. Default is
"Time". It takes value passed from \code{getFigure()}.}

\item{outcome}{A string or character vector representing the name(s) of the longitudinal process(es) under examination.
It takes value passed from \code{getFigure()}.}
}
\value{
A ggplot object or a list of ggplot objects.
}
\description{
This is an internal function that generates a ggplot object for a fitted model. It is called by the \code{getFigure}
function.
}
\keyword{internal}
