% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MED.loading_helper.R
\name{getMED.loadings}
\alias{getMED.loadings}
\title{Get Factor Loadings for a Longitudinal Mediation Model with Specified Functional Curves}
\usage{
getMED.loadings(
  t_var,
  y_var,
  m_var,
  x_type,
  x_var,
  curveFun,
  y_records,
  m_records,
  x_records = NULL
)
}
\arguments{
\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding longitudinal variable at each study wave. It takes the value passed from \code{getMediation()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{m_var}{A string specifying the prefix of the column names corresponding to the mediator variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMediation()}.}

\item{x_var}{A string specifying the baseline predictor if \code{x_type = "baseline"}, or the prefix of the column names
corresponding to the predictor variable at each study wave if \code{x_type = "longitudinal"}. It takes the value passed from
\code{getMediation()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options include: \code{"linear"}
(or \code{"LIN"}), and \code{"bilinear spline"} (or \code{"BLS"}). It takes the value passed from \code{getMediation()}.}

\item{y_records}{A numeric vector specifying indices of the study waves for the outcome variable. It is the first vector
in \code{records} specified in \code{getMediation()}.}

\item{m_records}{A numeric vector specifying indices of the study waves for the mediator variable. It is the second vector
in \code{records} specified in \code{getMediation()}.}

\item{x_records}{A numeric vector specifying indices of the study waves for the predictor variable. Default value is \code{NULL},
which is for \code{x_type = "baseline"}. If \code{x_type = "longitudinal"}, it is the third vector in \code{records} specified in
\code{getMediation()}.}
}
\value{
A list containing the specification of definition variables (i.e., individual measurement occasions) and factor
loadings of a longitudinal mediation model.
}
\description{
This function specifies the factor loadings for a longitudinal mediation model with given functional form.
}
\keyword{internal}
