% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNI.GF_helper.R
\name{getUNI.GF}
\alias{getUNI.GF}
\title{Derive Individual Growth Factors for Latent Growth Curve Models or Latent Change Score Models with Time-Invariant Covariates (If Any)}
\usage{
getUNI.GF(dat_traj, dat_time, nT, curveFun)
}
\arguments{
\item{dat_traj}{A data frame containing the records for the repeated measurements.}

\item{dat_time}{A data frame containing the records for measurement occasions associated with the repeated
measurements.}

\item{nT}{An integer representing the number of repeated measurements.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getUNI.initial()} or \code{getMULTI.initial()} or \code{getTVC.initial()} or \code{getMIX.initial()}.}
}
\value{
A data frame containing the derived individual growth factors from the raw data.
}
\description{
This function derives individual growth factors for the specified latent growth curve model or
latent change score model from raw data. These individual growth factors help further compute initial values
for parameters related to growth factors, time-invariant covariates (if any), and path coefficients (if any).
}
\keyword{internal}
