% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGroup.SUBMODEL.LCSM_helper.R
\name{getsub.LCSM_m}
\alias{getsub.LCSM_m}
\title{Define Latent Change Score Models as Class-specific Models (Submodels) for a Longitudinal Multiple Group Model}
\usage{
getsub.LCSM_m(
  dat,
  nClass,
  grp_var,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  growth_TIC,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions for each longitudinal process, and time-invariant covariates (TICs) if any.
It takes the value passed from \code{getMGroup()}.}

\item{nClass}{An integer specifying the number of manifested classes for the multiple group model. It takes the value passed from \code{getMGroup()}.}

\item{grp_var}{A string specifying the column that indicates manifested classes. It takes the value passed from \code{getMGroup()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getMGroup()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMGroup()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for latent change score
models include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}), \code{"Jenss-Bayley"}
(or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getMGroup()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the value
passed from \code{getMGroup()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getMGroup()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) contributing to the
variability of growth factors if any. It takes the value passed from \code{getMGroup()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMGroup()} or
derived by the helper function \code{getMGroup.initial()}.}
}
\value{
A list of manifest and latent variables and paths for an mxModel object.
}
\description{
This function defines latent change score models as class-specific models (submodels) for a longitudinal multiple group
model.
}
\keyword{internal}
