% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVC.initial_helper.R
\name{getTVC.initial}
\alias{getTVC.initial}
\title{Compute Initial Values for Parameters of Latent Growth Curve Models or Latent Change Score Models with a Time-varying
Covariate and Time-invariant Covariates (if any)}
\usage{
getTVC.initial(
  dat,
  t_var,
  y_var,
  curveFun,
  records,
  growth_TIC,
  TVC,
  decompose,
  res_scale,
  res_cor
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements (for the longitudinal outcome and time-varying covariates), occasions, and time-invariant covariates
(TICs) if any. It takes the value passed from \code{getTVCmodel()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave. It takes
the value passed from \code{getTVCmodel()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave. It
takes the value passed from \code{getTVCmodel()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value
passed from \code{getTVCmodel()}.}

\item{records}{A numeric vector specifying the indices of the observed study waves. It takes the value passed from \code{getTVCmodel()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) that account for the
variability of growth factors, if any. It takes the value passed from \code{getTVCmodel()}.}

\item{TVC}{A string specifying the prefix of the column names corresponding to the time-varying covariate at each study wave.
It takes the value passed from \code{getTVCmodel()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the value
passed from \code{getTVCmodel()}.}

\item{res_scale}{A numeric value or numeric vector. For a model with \code{decompose = 0}, it is a numeric value representing
the scaling factor used to calculate the initial value for the residual variance of the longitudinal outcome. In cases where
\code{decompose != 0}, it is a numeric vector of user-specified scaling factors used to calculate the initial values for the
residual variance of both the longitudinal outcome and the time-varying covariate. It takes the value passed from \code{getTVCmodel()}.}

\item{res_cor}{A numeric value. When \code{decompose != 0}, this represents the user-specified residual correlation between the
longitudinal outcome and the time-varying covariate, which is used to calculate the corresponding initial value. If \code{decompose = 0},
this should be \code{NULL}. It takes the value passed from \code{getTVCmodel()}.}
}
\value{
A list containing the initial values for parameters related to growth factors, TVC, TICs (if any), and path
coefficients (if any) for a latent growth curve model or a latent change score model with a time-varying covariate and
time-invariant covariates (if any).
}
\description{
This function computes the initial values of the parameters for a latent growth curve model or a latent change
score model with a time-varying covariate and time-invariant covariates (if any).
}
\keyword{internal}
