% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexpf.R
\name{SSexpf}
\alias{SSexpf}
\alias{expf}
\title{self start for an exponential function}
\usage{
expf(x, a, c)

SSexpf(x, a, c)
}
\arguments{
\item{x}{input vector (x)}

\item{a}{represents the value at x = 0}

\item{c}{represents the exponential rate}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

expf: vector of the same length as x using the profd function
}
\description{
Self starter for a simple exponential function
}
\details{
This is the exponential function \deqn{y = a * exp(c * x)}

For more details see: Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:15
y <- expf(x, 10, -0.3) + rnorm(15, 0, 0.2)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSexpf(x, a, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
