% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timedist.R
\name{timedist}
\alias{timedist}
\title{Fit the Franco model}
\usage{
timedist(data, x, y, r, c, t, ...)
}
\arguments{
\item{data}{The data to be included in the model.}

\item{x, y}{The x and y values in the data, where the y values are the
proportions.}

\item{r, c, t}{The starting parameters for the model.}

\item{...}{Additional parameters to be passed to
\code{\link[minpack.lm]{nlsLM}}.}
}
\description{
Fit the Franco model
}
\details{
The \code{\link[minpack.lm]{nlsLM}} function is used instead of the
  \code{\link[stats]{nls}} function in order to use the Levenberg-Marquardt
  algorithm which is an extremely robust method of curve-fitting as it is
  able to switch between Gauss-Newton and gradient descent. This allows it to
  cope with far-off-optimal starting values. The standard nls function does
  not use Levenberg-Marquardt; it instead uses the Gauss-Newton type, the
  PORT routines and a partial linear fit.
}
\examples{
tdTilia <- tdData(tilia, x = "Day", y = "Trees")
model <- timedist(data = tdTilia, x = "Day", y = "propMax", r = 0.1, c = 0.5,
                  t = 120)
model

}
