% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SocAnx.post.summary}
\alias{SocAnx.post.summary}
\title{Posterior summary from Social Anxiety NMA}
\format{A \code{summary.mcmc} object. The key components for our use are:
  \describe{ \item{statistics}{Matrix containing the posterior summary
  statistics of the variables \code{d}, \code{delta}, and \code{diff}, with
  columns for \code{Mean}, \code{SD}, \code{Naive SE}, and \code{Time-series
  SE} (also known as the Monte-Carlo standard error)} \item{quantiles}{Matrix
  containing the posterior 2.5\%, 25\%, 50\%, 75\%, and 97.5\% quantiles of
  the variables \code{d}, \code{delta}, and \code{diff}}}}
\source{
Generated from WinBUGS output, using the WinBUGS code from
  Mayo-Wilson et al. (2014). See also \code{vignette("Examples", package =
  "nmathresh")}.
}
\usage{
SocAnx.post.summary
}
\description{
A \code{summary.mcmc} object of the type produced by the \code{coda} package,
containing the requisite posterior summary information on the variables
\code{d} (basic treatment effect parameters), \code{delta} (shrunken random
effects estimates for each study), and \code{diff} (contrasts of treatment
effect parameters).
}
\references{
Mayo-Wilson E, Dias S, Mavranezouli I, Kew K, Clark DM, Ades AE,
  et al. Psychological and pharmacological interventions for social anxiety
  disorder in adults: a systematic review and network meta-analysis. Lancet
  Psychiatry 2014;1:368-76.
  http://dx.doi.org/10.1016/S2215-0366(14)70329-3
}
\seealso{
\code{\link[coda]{summary.mcmc}}, \code{\link{SocAnx.post.cov}}
}
\keyword{datasets}
