% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistftest.R
\name{logistftest}
\alias{logistftest}
\title{Penalized likelihood ratio test}
\usage{
logistftest(
  object,
  test,
  values,
  firth = TRUE,
  beta0,
  weights,
  control,
  col.fit.object = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{logistf} object}

\item{test}{righthand formula of parameters to test (e.g. ~ B + D - 1). As default 
all parameter apart from the intercept are tested. If the formula includes -1, the 
intercept is omitted from testing. As alternative to the formula one can give 
the indexes of the ordered effects to test (a vector of integers). To test only the 
intercept specify test = ~ - . or test = 1.}

\item{values}{Null hypothesis values, default values are 0. For testing the specific hypothesis 
B1=1, B4=2, B5=0 we specify test= ~B1+B4+B5-1 and values=c(1, 2,0).}

\item{firth}{Use of Firth's (1993) penalized maximum likelihood (firth=TRUE, default) or 
the standard maximum likelihood method (firth=FALSE) for the logistic regression. 
Note that by specifying pl=TRUE and firth=FALSE (and probably lower number of iterations) 
one obtains profile likelihood confidence intervals for maximum likelihood logistic 
regression parameters.}

\item{beta0}{Specifies the initial values of the coefficients for the fitting algorithm}

\item{weights}{Case weights}

\item{control}{Controls parameters for iterative fitting}

\item{col.fit.object}{Numerical vector containing the positions of the variables to fit, if not
specified: all variables are taken}

\item{...}{further arguments passed to logistf.fit}
}
\value{
The object returned is of the class logistf and has the following attributes:
  \item{testcov}{A vector of the fixed values of each covariate; NA stands for a parameter which is not tested.}
  \item{loglik}{A vector of the (penalized) log-likelihood of the full and the restricted models. If 
  the argument beta0 not missing, the full model isn't evaluated}
  \item{df}{The number of degrees of freedom in the model}
  \item{prob}{The p-value of the test}
  \item{call}{The call object}
  \item{method}{Depending on the fitting method 'Penalized ML' or 'Standard ML'}
  \item{beta}{The coefficients of the restricted solution}
}
\description{
This function performs a penalized likelihood ratio test on some (or all) selected factors. 
The resulting object is of the class logistftest and includes the information printed by the
proper print method.
}
\details{
This function performs a penalized likelihood ratio test on some (or all) selected factors. The resulting object is of the class logistftest and includes the information printed by the proper print 
method. Further documentation can be found in Heinze & Ploner (2004). 
In most cases, the functionality of the logistftest function is replaced by anova.logistf, which 
is a more standard way to perform likelihood ratio tests. However, as shown in the example below, logistftest provides some specials such as testing against non-zero values. (By the way, 
anova.logistf calls logistftest.
}
\examples{
data(sex2) 
fit<-logistf(case ~ age+oc+vic+vicl+vis+dia, data=sex2)
logistftest(fit, test = ~ vic + vicl - 1, values = c(2, 0))


}
\references{
Firth D (1993). Bias reduction of maximum likelihood estimates. Biometrika 80, 27-38.


Heinze G, Ploner M (2004). Technical Report 2/2004: A SAS-macro, S-PLUS library and R 
package to perform logistic regression without convergence problems. Section of Clinical Biometrics, Department of Medical Computer Sciences, Medical University of Vienna, Vienna, Austria. 
http://www.meduniwien.ac.at/user/georg.heinze/techreps/tr2_2004.pdf 

Heinze G (2006). A comparative investigation of methods for logistic regression with separated or 
nearly separated data. Statistics in Medicine 25: 4216-4226
}
\author{
Georg Heinze
}
