% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnfor.R
\docType{package}
\name{nnfor-package}
\alias{nnfor}
\alias{nnfor-package}
\title{nnfor: Time Series Forecasting with Neural Networks}
\description{
Contains functions to facilitate automatic time series modelling with neural networks.
Allows fully automatic, semi-manual or fully manual specification of networks. For details of the
specification methodology see: (i) Crone and Kourentzes (2010) <doi:10.1016/j.neucom.2010.01.017>;
and (ii) Kourentzes et al. (2014) <doi:10.1016/j.eswa.2013.12.011>.
}
\references{
\itemize{
\item{For an introduction to neural networks see: Ord K., Fildes R., Kourentzes N. (2017) \href{http://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting 2e}. \emph{Wessex Press Publishing Co.}, Chapter 10.}
\item{For ensemble combination operators see: Kourentzes N., Barrow B.K., Crone S.F. (2014) \href{http://kourentzes.com/forecasting/2014/04/19/neural-network-ensemble-operators-for-time-series-forecasting/}{Neural network ensemble operators for time series forecasting}. \emph{Expert Systems with Applications}, \bold{41}(\bold{9}), 4235-4244.}
\item{For variable selection see: Crone S.F., Kourentzes N. (2010) \href{http://kourentzes.com/forecasting/2010/04/19/feature-selection-for-time-series-prediction-a-combined-filter-and-wrapper-approach-for-neural-networks/}{Feature selection for time series prediction – A combined filter and wrapper approach for neural networks}. \emph{Neurocomputing}, \bold{73}(\bold{10}), 1923-1936.}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{http://kourentzes.com/forecasting/2017/02/10/forecasting-time-series-with-neural-networks-in-r/}
}

}
\author{
\strong{Maintainer}: Nikolaos Kourentzes \email{nikolaos@kourentzes.com}

}
