% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_postgis.R
\name{st_postgis}
\alias{st_postgis}
\title{Send 'sf' layer to a PostGIS query}
\usage{
st_postgis(x, con, query, prefix = "temporary_nngeo_layer_")
}
\arguments{
\item{x}{Object of class \code{sf}}

\item{con}{Connection to PostgreSQL database with PostGIS extension enabled. Can be created using function \code{RPostgreSQL::dbConnect}}

\item{query}{SQL query, which may refer to layer \code{x} as \code{x} and to the geometry column of the \code{x} layer as \code{geom} (see examples)}

\item{prefix}{Prefix for storage of temporarily layer in the database}
}
\value{
Returned result from the database: an \code{sf} layer in case the result includes a geometry column, otherwise a \code{data.frame}
}
\description{
The function sends a query plus an \code{sf} layer to PostGIS, saving the trouble of manually importing the layer and exporting the result
}
\examples{
\dontrun{

# Database connection and 'sf' layer
source("~/Dropbox/postgis_159.R")  ## Creates connection object 'con'
x = towns

# Query 1: Buffer
query = "SELECT ST_Buffer(geom, 0.1, 'quad_segs=2') AS geom FROM x LIMIT 5;"
st_postgis(x, con, query)

# Query 2: Extrusion
query = "SELECT ST_Extrude(geom, 0, 0, 30) AS geom FROM x LIMIT 5;"
st_postgis(x, con, query)
}
}
