% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rassocI}
\alias{rassocI}
\title{Generation of Points Associated in the Type I Sense with a Given Set of Points}
\usage{
rassocI(X1, n2, p)
}
\arguments{
\item{X1}{A set of 2D points representing the reference points, also referred as class 1 points.
The generated points are associated in a type I sense (in a circular/radial fashion) with these points.}

\item{n2}{A positive integer representing the number of class 2 (i.e. \eqn{X_2}) points to be generated.}

\item{p}{A real number between 0 and 1 representing the attraction probability of class 2 points associated
with a randomly selected class 1 point (see the description below).}
}
\value{
A \code{list} with the elements 
\item{pat.type}{equals \code{"ref.gen"} for the bivariate pattern of association of class 2 (i.e. \eqn{X_2}) points with the reference
points (i.e. \eqn{X_1}), indicates reference points are required to be entered as an argument in the function}
\item{type}{The type of the point pattern}
\item{parameters}{Radial (i.e. circular) between class attraction parameter controlling the level of association}
\item{gen.points}{The output set of generated points (i.e. class 2 points) associated with reference (i.e.
\eqn{X_1} points)}
\item{ref.points}{The input set of reference points \eqn{X_1}, i.e., points with which generated class 2
points are associated.}
\item{desc.pat}{Description of the point pattern}
\item{lab}{The class labels of the generated points, it is \code{NULL} for this function, since only class 2
points are generated in this pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated class 2 points and
the number of reference (i.e. \eqn{X_1}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and
the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Generates \code{n_2} 2D points associated with the given set of points (i.e. reference points) \eqn{X_1} in the
type I fashion with circular (or radial) between class attraction parameter \code{p}, which is a probability value between 0 and 1.
The generated points are intended to be from a different class, say class 2 (or \eqn{X_2} points) than the reference
(i.e. \eqn{X_1} points, say class 1 points, denoted as \code{X1} as an argument of the function). 
To generate \eqn{n_2} (denoted as \code{n2} as an argument of the function) \eqn{X_2} points, \eqn{n_2} of \eqn{X_1} points are randomly selected (possibly with replacement) and
for a selected \code{X1} point, say \eqn{x_{1ref}}, a \eqn{Uniform(0,1)} number, \eqn{U}, is generated.
If \eqn{U \le p}, a new point from the class 2, say \eqn{x_{2new}}, is generated within a
circle with radius equal to the distance to the closest \eqn{X_1} point (uniform in the polar coordinates),
else the new point is generated uniformly
within the smallest bounding box containing \eqn{X_1} points.
That is, if \eqn{U \le p}, \eqn{x_{2new} = x_{1ref}+r_u c(\cos(t_u),\sin(t_u))}
where \eqn{r_u \sim U(0,rad)} and \eqn{t_u \sim U(0, 2\pi)} with \eqn{rad=\min(d(x_{1ref},X_1\setminus \{x_{1ref}\}))},
else \eqn{x_{2new} \sim rect(X_1)} where \eqn{rect(X_1)} is the smallest bounding box containing \eqn{X_1} points.
Note that, the level of association increases as \code{p} increases, and the association vanishes
when \code{p} approaches to 0.

Type I association is closely related to Type C association in
\insertCite{ceyhan:serra-2014;textual}{nnspat}, see the function \code{\link{rassocC}}
and also other association types.
In the type C association pattern
the new point from the class 2, \eqn{x_{2new}}, is generated (uniform in the polar coordinates) within a circle
centered at \eqn{x_{1ref}} with radius equal to \eqn{r_0},
in type U association pattern \eqn{x_{2new}} is generated similarly except it is uniform in the circle.
In type G association, \eqn{x_{2new}} is generated from the bivariate normal distribution centered at \eqn{x_{1ref}} with covariance
\eqn{\sigma I_2} where \eqn{I_2} is \eqn{2 \times 2} identity matrix.
}
\examples{
n1<-20; n2<-1000;  #try also n1<-10; n2<-1000;

p<- .75 #try also .25, .5, .9, runif(1)
#with default bounding box (i.e., unit square)
X1<-cbind(runif(n1),runif(n1))  #try also X1<-1+cbind(runif(n1),runif(n1))

Xdat<-rassocI(X1,n2,p)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rassocC}}, \code{\link{rassocG}}, \code{\link{rassocU}}, and \code{\link{rassoc}}
}
\author{
Elvan Ceyhan
}
