% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\docType{methods}
\name{dbConnect,AthenaDriver-method}
\alias{dbConnect,AthenaDriver-method}
\alias{dbConnect}
\title{Connect to Athena using R's sdk paws}
\usage{
\S4method{dbConnect}{AthenaDriver}(drv, aws_access_key_id = NULL,
  aws_secret_access_key = NULL, aws_session_token = NULL,
  schema_name = "default", work_group = NULL, poll_interval = NULL,
  encryption_option = c("NULL", "SSE_S3", "SSE_KMS", "CSE_KMS"),
  kms_key = NULL, profile_name = NULL, role_arn = NULL,
  role_session_name = sprintf("paws-athena-session-\%s",
  as.integer(Sys.time())), duration_seconds = 3600L,
  s3_staging_dir = NULL, region_name = NULL, ...)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{aws_access_key_id}{AWS access key ID}

\item{aws_secret_access_key}{AWS secret access key}

\item{aws_session_token}{AWS temporary session token}

\item{schema_name}{The schema_name to which the connection belongs}

\item{work_group}{The name of the \href{https://aws.amazon.com/about-aws/whats-new/2019/02/athena_workgroups/}{work group} to run Athena queries , Currently defaulted to \code{NULL}.}

\item{poll_interval}{Amount of time took when checking query execution status. Default set to a random interval between 0.5 - 1 seconds.}

\item{encryption_option}{Athena encryption at rest \href{https://docs.aws.amazon.com/athena/latest/ug/encryption.html}{link}. 
Supported Amazon S3 Encryption Options ["NULL", "SSE_S3", "SSE_KMS", "CSE_KMS"]. Connection will default to NULL,
usually changing this option is not required.}

\item{kms_key}{\href{https://docs.aws.amazon.com/kms/latest/developerguide/overview.html}{AWS Key Management Service}, 
please refer to \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html}{link} for more information around the concept.}

\item{profile_name}{The name of a profile to use. If not given, then the default profile is used.
To set profile name, the \href{https://aws.amazon.com/cli/}{AWS Command Line Interface} (AWS CLI) will need to be configured.
To configure AWS CLI please refer to: \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html}{Configuring the AWS CLI}.}

\item{role_arn}{The Amazon Resource Name (ARN) of the role to assume (such as \code{arn:aws:sts::123456789012:assumed-role/role_name/role_session_name})}

\item{role_session_name}{An identifier for the assumed role session. By default `RAthena` creates a session name \code{sprintf("RAthena-session-\%s", as.integer(Sys.time()))}}

\item{duration_seconds}{The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to the maximum session duration setting for the role. 
This setting can have a value from 1 hour to 12 hours. By default duration is set to 3600 seconds (1 hour).}

\item{s3_staging_dir}{The location in Amazon S3 where your query results are stored, such as \code{s3://path/to/query/bucket/}}

\item{region_name}{Default region when creating new connections. Please refer to \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{link} for 
AWS region codes (region code example: Region = EU (Ireland)     \code{ region_name = "eu-west-1"})}

\item{...}{other parameters for \code{paws} session}
}
\value{
\code{dbConnect()} returns a s4 class. This object is used to communicate with AWS Athena.
}
\description{
It is never advised to hard-code credentials when making a connection to Athena (even though the option is there). Instead it is advised to use
\code{profile_name} (set up by \href{https://aws.amazon.com/cli/}{AWS Command Line Interface}), 
\href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name roles} or environmental variables. Here is a list
of supported environment variables:
\itemize{
\item{\strong{AWS_ACCESS_KEY_ID:} is equivalent to the \code{dbConnect} parameter - \code{aws_access_key_id}}
\item{\strong{AWS_SECRET_ACCESS_KEY:} is equivalent to the \code{dbConnect} parameter - \code{aws_secret_access_key}}
\item{\strong{AWS_SESSION_TOKEN:} is equivalent to the \code{dbConnect} parameter - \code{aws_session_token}}
\item{\strong{AWS_ROLE_ARN:} is equivalent to the \code{dbConnect} parameter - \code{role_arn}}
\item{\strong{AWS_EXPIRATION:} is equivalent to the \code{dbConnect} parameter - \code{duration_seconds}}
\item{\strong{AWS_ATHENA_S3_STAGING_DIR:} is equivalent to the \code{dbConnect} parameter - \code{s3_staging_dir}}
\item{\strong{AWS_ATHENA_WORK_GROUP:} is equivalent to \code{dbConnect} parameter - \code{work_group}}
}
}
\examples{
\dontrun{
# Connect to Athena using your aws access keys
 library(DBI)
 con <- dbConnect(RAthena:athena(),
                  aws_access_key_id='YOUR_ACCESS_KEY_ID', # 
                  aws_secret_access_key='YOUR_SECRET_ACCESS_KEY',
                  s3_staging_dir='s3://path/to/query/bucket/',
                  region_name='us-west-2')
 dbDisconnect(con)
 
# Connect to Athena using your profile name
# Profile name can be created by using AWS CLI
 con <- dbConnect(RAthena::athena(),
                  profile_name = "YOUR_PROFILE_NAME",
                  s3_staging_dir = 's3://path/to/query/bucket/')
 dbDisconnect(con)
 
# Connect to Athena using ARN role
 con <- dbConnect(athena(),
                  profile_name = "YOUR_PROFILE_NAME",
                  role_arn = "arn:aws:sts::123456789012:assumed-role/role_name/role_session_name",
                  s3_staging_dir = 's3://path/to/query/bucket/')
                 
 dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbConnect}}
}
