% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{docdb_query}
\alias{docdb_query}
\title{Get documents or parts with filtering query}
\usage{
docdb_query(src, key, query, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
\code{\link[=src_duckdb]{src_duckdb()}} or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) The name of the container in the
database backend (corresponds to \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch, and to
a table name for DuckDB, SQLite and PostgreSQL)}

\item{query}{(character) A JSON query string, see examples.
Can use comparisons / tests (\verb{$lt}, \verb{$lte}, \verb{$gt}, \verb{$gte},
\verb{$ne}, \verb{$in}, \verb{$regex}), with logic operators (\verb{$and},
\verb{$or}, \code{(}, \verb{)}), including nested queries, see examples.
\verb{$regex} is case-sensitive.
Note that the query should target a field that holds a
scalar or an array of scalars, not more complex objects.}

\item{...}{Optional parameters:
\itemize{
\item Specify \code{fields} as a JSON string of fields to be returned
from anywhere in the tree, or to be excluded from being returned,
e.g. \code{fields  = '{"nameOfMy.SubFieldToInclude:" 1, "_id": 0}'}
and see examples. If \code{fields} is not specified, the complete
JSON document is returned. For \code{src_postgres()}, only fewer
than 50 fields can be requested to be returned by the function.
\item Specify \code{limit} (integer) for the maximum number of documents
to be returned. If \code{NULL} or not set (default), 10,000 for
Elasticsearch and all documents for MongoDB, SQLite,
CouchDB, PostgreSQL, and DuckDB.
\item Specify \code{listfields = TRUE} to return just the names of
all fields, from all documents or from the maximum number of
documents as specified in \code{limit}.
}}
}
\value{
Data frame with requested documents, may have nested
lists in columns; \code{NULL} if no documents could be found.
If \code{listfields} is specified: a vector of all field names
in dot path notation.
}
\description{
Complements the databases' native query and filtering functions
by using \code{\link[jqr:jqr]{jqr::jqr()}}.
If \code{query = "{}"} and neither \code{fields}
nor \code{listfields} is specified, runs \code{\link[=docdb_get]{docdb_get()}}.
}
\note{
A dot in \code{query} or \code{fields} is interpreted as a dot path,
pointing to a field nested within another, e.g. \code{friends.id} in
the example.
}
\examples{
\dontrun{
src <- src_sqlite()

docdb_create(src, "myKey", mtcars)
docdb_create(src, "myKey", contacts)
docdb_create(src, "myKey", mapdata)

docdb_query(src, "myKey", query = '{"mpg":21}')
docdb_query(src, "myKey", query = '{"mpg":21, "gear": {"$lte": 4}}')
docdb_query(src, "myKey", query = '{"mpg":21}', fields = '{"_id":0, "mpg":1, "cyl":1}')
docdb_query(src, "myKey", query = '{"_id": {"$regex": "^.+0.*$"}}', fields = '{"gear": 1}')

docdb_query(src, "myKey", query = '{"$and": [{"mpg": {"$lte": 18}}, {"gear": {"$gt": 3}}]}')
docdb_query(src, "myKey", query = '{}', fields = '{"_id":0, "mpg":1, "cyl":1}')

docdb_query(src, "myKey", query = '{"$and": [{"age": {"$gt": 21}},
 {"friends.name": {"$regex": "^B[a-z]{3,9}.*"}}]}')
docdb_query(src, "myKey", query = '{"$or": [{"rows.elements.status": "OK"}, {"$and": [
 {"_id": "5cd6785325ce3a94dfc54096"}, {"friends.name": {"$regex": "^B[a-z]{3,90}.*"}}]}]}')
docdb_query(src, "myKey", query = '{"$and": [{"_id": "5cd6785325ce3a94dfc54096"},
 {"friends.name": {"$regex": "^B[a-z]{3,90}.*"}}]}')
docdb_query(src, "myKey", query = '{"origin_addresses": {"$in": ["Santa Barbara, CA, USA",
 "New York, NY, USA"]}}', fields = '{"age": 1, "friends.id": 1, "_id": 0,
 "rows.elements.status": 1}')

docdb_query(src, "myKey", query = '{"rows.elements.status": "OK"}', listfields = TRUE)

}
}
