% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox_to_poly.R
\name{bbox_to_poly}
\alias{bbox_to_poly}
\title{Create a bounding box \code{sf} object}
\usage{
bbox_to_poly(bbox = NA, xmin = NA, ymin = NA, xmax = NA, ymax = NA, crs = 4326)
}
\arguments{
\item{bbox}{numeric vector of 4 elements representing the coordinates of the
bounding box. Values should be \code{c(xmin, ymin, xmax, ymax)}}

\item{xmin, ymin, xmax, ymax}{alternatively, you can use these named parameters
instead of \code{bbox}}

\item{crs}{coordinate reference system, something suitable as input to \link[sf]{st_crs}}
}
\value{
A \code{sf} object
}
\description{
Create a \code{sf} polygon object from the coordinates of a bounding box
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.
}
\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# bounding box of Germany
bbox_GER <- c(5.86631529, 47.27011137, 15.04193189, 55.09916098)

bbox_GER_sf <- bbox_to_poly(bbox_GER)


library(ggplot2)

ggplot(bbox_GER_sf) +
  geom_sf()
\donttest{
# Extract the bounding box of a sf object
Texas <- geo_lite_sf("Texas", points_only = FALSE)
bbox <- sf::st_bbox(Texas)

bbox

bbox_Texas <- bbox_to_poly(bbox)

ggplot(bbox_Texas) +
  geom_sf(col = "red") +
  geom_sf(data = Texas)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[sf:st_as_sfc]{sf::st_as_sfc()}}

Other spatial: 
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{reverse_geo_lite_sf}()}

Other amenity: 
\code{\link{geo_amenity_sf}()},
\code{\link{geo_amenity}()},
\code{\link{osm_amenities}}
}
\concept{amenity}
\concept{spatial}
