% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_amenity_sf.R
\name{geo_amenity_sf}
\alias{geo_amenity_sf}
\title{Geocode amenities in Spatial format}
\usage{
geo_amenity_sf(
  bbox,
  amenity,
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE,
  strict = FALSE
)
}
\arguments{
\item{bbox}{A numeric vector of latitude and longitude
\verb{(<min_latitude>, <min_longitude>, <max_latitude>, <max_longitude>)} that
restrict the search area. See \strong{Details}.}

\item{amenity}{A character of a vector of character with the amenities to be
geolocated (i.e. \code{c("pub", "restaurant")}). See \strong{Details} and
\link{osm_amenities}.}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all available data from the API service.
If \code{FALSE} (default) only address columns are returned. See also
\code{return_addresses}.}

\item{return_addresses}{return input addresses with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}

\item{strict}{Logical \code{TRUE/FALSE}. Force the results to be included inside
the \code{bbox}. Note that Nominatim default behavior may return results located
outside the provided bounding box.}
}
\value{
A \code{sf} object with the results.
}
\description{
This function search amenities as defined by OpenStreetMap on a restricted
area defined by a bounding box in the form of
\verb{(<min_latitude>, <min_longitude>, <max_latitude>, <max_longitude>)}. This
function returns the \pkg{sf} spatial object associated with the query, see
\code{\link[=geo_amenity]{geo_amenity()}} for retrieving the data in \code{tibble} format.
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.

For a full list of valid amenities see
\url{https://wiki.openstreetmap.org/wiki/Key:amenity}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item administrative areas, major buildings and the like will be
returned as polygons
\item rivers, roads and their like as lines
\item amenities may be points even in case of a \code{points_only = FALSE} call
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Madrid, Spain

library(ggplot2)

bbox <- c(-3.888954, 40.311977, -3.517916, 40.643729)

# Restaurants and pubs

rest_pub <- geo_amenity_sf(bbox, c("restaurant", "pub"), limit = 50)

ggplot(rest_pub) +
  geom_sf()

# Hospital as polygon

hosp <- geo_amenity_sf(bbox, "hospital", points_only = FALSE)

ggplot(hosp) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_amenity]{geo_amenity()}}

Search amenities: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_amenity}()},
\code{\link{osm_amenities}}

Geocoding strings: 
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_address_lookup}()},
\code{\link{geo_amenity}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite}()}

Get spatial (`sf`) objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{amenity}
\concept{geocoding}
\concept{spatial}
