% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPCs_ggplot.R
\name{vpcfig3}
\alias{vpcfig3}
\title{Visual Predictive Check (VPC) based on raw Perl-speaks-NONMEM (PsN) generated VPC files.}
\usage{
vpcfig3(sdtab, vpcdir, use.model.path = TRUE, dv = "DV", idvs = "TIME",
  numerical = rep(TRUE, length(idvs)), strata = NULL, method = c("loess",
  "spline"), maxNsim = NULL, knots = 5, minobs = 8, col.data = "gray20",
  cex.data = 1, pch.data = 19, alpha.data = 0.5, col.line = "grey20",
  lwd.line = 1, lty.line = 1, col.segm = "steelblue", alpha.segm = 0.6,
  type = 3)
}
\arguments{
\item{sdtab}{file path to sdtab output from model, ALTERNATIVELY a data.fram of the loaded sdtab file. See details.}

\item{vpcdir}{Path of directory of the VPC files, ALTERNATIVELY a data.frame of the loaded matrix file. See details.}

\item{use.model.path}{Load files from a global defined model library (TRUE=default).
If so will look for a global character vector named \code{model.path}}

\item{dv}{Dependent variable (y-axis)}

\item{idvs}{Independent variable (x-axis)}

\item{numerical}{Logical indicator if idvs is numerical variable(TRUE) or catacorical (FALSE), default=TRUE
NOTE: must be of same length as idvs}

\item{strata}{Stratification column of sdtab, NOTE must be a columns in the sdtab}

\item{method}{either "loess" (deault) or "spline" for continuous IDV's}

\item{maxNsim}{maximum number of simulations used to use for computing VPC.
Default=NULL, meaning all simulations in the input datafile/data.frame will be used.}

\item{knots}{number of knots (bins) for method spline. See details.}

\item{minobs}{minimum number of observations per number of knots(bins) for method spline. See details.}

\item{col.data}{color for data points, passed to geom_point, default="gray20"}

\item{cex.data}{cex for data points, passed to geom_point, default=1}

\item{pch.data}{plot symbol (pch) for data points, passed to geom_point, default=19}

\item{alpha.data}{alpha for plotting of data points, passed to geom_point, default=0.5}

\item{col.line}{line color for mean of data, passed to geom_line, default="gray20"}

\item{lwd.line}{line width (lwd) for mean of data, passed to geom_line, default=1}

\item{lty.line}{line type (lty) for mean of data, passed to geom_line, default=1}

\item{col.segm}{Color of CI region for model, passed to geom_ribbon, default="steelblue"}

\item{alpha.segm}{alpha of CI region for model, passed to geom_polygon, default=0.6}

\item{type}{type of VPC plot:

1=display model regions only,

2=as 1 + mean of data,

3= as 2 + points for data.

type=0 can also be used and then no graph is produced but instead a list with 2 dataframes is returned.
one for the vpcresult and on for the observed data in the vpctab file.}
}
\value{
A ggplot object if type>0, or if type==0 a list of 3 data.frames, D1=individual data, D3=mean data, D5=mean model with confidence intervals
}
\description{
This function compile VPC simulated data from the vpc command in Pearl Speaks NONMEM (PsN).
The complied data is then plotted (unless type=0) and returned (ggplot-object) and can then be
further modifed.
}
\details{
The sdtab and vpcdir can either be file name of the sdtab file and the folder name of the psn generated VPC,
or can be data.frames of sdtab and simulation data loaded outside vpcfig3, see example below for the latter case.

Loading the sdtab and matrix file outside vpcfig2 is convenient when dosing multipe VPC plots or for VPC
using new strata ( or idv) variables not included in the sdtab file, see example.

If vpcdir is given as a folder names, then a matrix.csv file is loaed from the /m1 subfolder of vpcdir.

The raw simulated results from the matrix file is loaded to compute mean of data with confidence intervals
For numerical idv variables loess-smooth or linear spline is used on observed actual data and on simulated data.
For categorical idv mean is computed for each unique value if idv

For method=spline, the actual number of knots(bins) is set as min(knots,N/minobs) where N is the number of observations.
}
\examples{
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab", package = "nonmem2R")
file2 <- system.file("extdata", "DV_matrix.csv", package = "nonmem2R")

#load sdtab and matrix file
sdtab<-read.table(file=file1,skip=1,header=TRUE)
vpc<-read.table(file=file2,header=FALSE,sep=",")

# VPC stratified by gender
vpcfig3(sdtab,vpc,dv="DV",idvs="TAD",strata="SEX")

# create new strata variable and do VPC
sdtab$age.group<-cut(sdtab$AGE,c(22,30,50))
vpcfig3(sdtab,vpc,dv="DV",idvs="TAD",strata="age.group")
}
