% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{eta.cov.GOF}
\alias{eta.cov.GOF}
\alias{eta.cat.GOF}
\alias{eta.pairs.GOF}
\title{Covariate and pairs ETA GOFs}
\usage{
eta.cov.GOF(data, covariates = c("AGE", "BWT"), ETA.subset = NULL,
  exclude.zero.ETA = FALSE, title = "", drop.fixed = TRUE,
  id.column = "ID", standardize = TRUE, refline = TRUE,
  type = c("all-in-one", "covariate-by-page", "eta-by-page"),
  layout = c("ETAbyROW", "ETAbyCOL"), add.loess = TRUE,
  control = GOF.control())

eta.cat.GOF(data, covariates = c("SEXM"), ETA.subset = NULL,
  exclude.zero.ETA = FALSE, title = "", drop.fixed = TRUE,
  id.column = "ID", standardize = TRUE, refline = TRUE,
  type = c("all-in-one", "covariate-by-page", "eta-by-page"),
  layout = c("ETAbyROW", "ETAbyCOL"), add.points = TRUE,
  control = GOF.control())

eta.pairs.GOF(data, ETA.subset = NULL, title = "", drop.fixed = TRUE,
  id.column = "ID", density2D = c("none", "upper", "lower"),
  standardize = TRUE, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{covariates}{covariates, list of character strings}

\item{ETA.subset}{index for subset of ETA's to plot. If NULL (default) all ETA's are plotted.}

\item{exclude.zero.ETA}{If set to TRUE any ETA==0 is excluded before plotting. This option is useful if the model have full shrinkage for subset of individuals e.g. for ETA on ED50 in patents on placebo or on dose==0.}

\item{title}{title}

\item{drop.fixed}{drop ETA's that are fixed, i.e. any ETA with the same value in all subjects}

\item{id.column}{column name that indicate subject identifier}

\item{standardize}{Standardize all ETA's  (e.g. scale to unit variance)}

\item{refline}{add reference line (default =TRUE) or not (FALSE)}

\item{type}{do all ETA's and covariates on one page (all-in-one), one page for each covariate (covariate-by-page), or one page for each ETA (eta-by-page)}

\item{layout}{Layout for ETA's and covariates}

\item{add.loess}{add loess smoother to plot (TRUE), or not (FALSE)}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}

\item{add.points}{add jittered points of data (TRUE), or not (FALSE)}

\item{density2D}{add 2D-density above (upper) or below (lower), or don't add (none)}
}
\description{
ETA's vs numerical covariates (eta.cov.GOF) and ETA's vs categorical covariates GOF plots on multiple
or single pages with reflines, data smoother, and caption added as reurned by get.caption.

eta.pairs.GOF provides a pairs plot of all ETA's.
}
\examples{
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab999", package = "nonmem2R")
sdtab<-read.table(file=file1,skip=1,header=TRUE)
set.script.name("MyScript.R")
eta.cov.GOF(sdtab,covariates=c("AGE","BWT"))
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab999", package = "nonmem2R")
sdtab<-read.table(file=file1,skip=1,header=TRUE)
set.script.name("MyScript.R")
eta.cat.GOF(sdtab,covariates=c("SEXM"))
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab999", package = "nonmem2R")
sdtab<-read.table(file=file1,skip=1,header=TRUE)
set.script.name("MyScript.R")
eta.pairs.GOF(sdtab)
}
