% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tad.R
\name{tad}
\alias{tad}
\title{Calculate Time Since Most Recent Dose}
\usage{
tad(
  x,
  dose = rep(FALSE, length(x)),
  addl = rep(0, length(x)),
  ii = rep(0, length(x)),
  index = rep(1, length(x)),
  pre = TRUE,
  ...
)
}
\arguments{
\item{x}{a numeric vector of event times}

\item{dose}{length x logical indicating which of x are dose times}

\item{addl}{length x integer: number of additional doses}

\item{ii}{length x numeric: interdose interval for addl}

\item{index}{length x factor (optional) indicating subgroups to evaluate}

\item{pre}{assume that simultaneous sample precedes implied dose}

\item{...}{passed to tod()}
}
\value{
numeric
}
\description{
Calculate time since most recent dose.  Considers ADDL, but may not work with simultaneous dose records.
}
\examples{
data(tad1)
x <- tad1
head(x)
x$tad <- tad(
   x = x$TIME,
   dose = x$EVID \%in\% c(1,4) & is.na(x$C),
   addl = x$ADDL,
   ii = x$II,
   index = x$ID
 )
head(x)
}
\seealso{
\code{\link{tod}}

Other tad: 
\code{\link{tod}()}
}
\concept{tad}
