% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{vuongtest}
\alias{vuongtest}
\alias{vuongtest-package}
\title{vuongtest.}
\usage{
vuongtest(object1, object2)
}
\arguments{
\item{object1}{a model object}

\item{object2}{a model object}
}
\value{
an object of class \code{vuongtest} containing test results.
}
\description{
vuongtest.

\code{vuongtest} formally tests pairs of models using theory provided
by Vuong (1989).  Functionality is available for models of classes
lm, glm, glm.nb, clm, hurdle, zeroinfl, mlogit, nls, polr, rlm,
and lavaan.
}
\details{
Users should take care to ensure that the two models have
the same dependent variable (or, for lavaan objects, identical
modeled variables), with observations ordered identically within
each model object.
}
\examples{
\dontrun{
require(MASS)
house1 <- glm(Freq ~ Infl + Type + Cont, family=poisson, data=housing)
house2 <- glm(Freq ~ Infl + Sat, family=poisson, data=housing)
house3 <- glm(Freq ~ Infl, family=poisson, data=housing)
## house3 is nested within house1 and house2
anova(house3, house1, test="Chisq")
anova(house2, house1, test="Chisq")

## house 2 is not nested in house1, so this test is invalid
anova(house2, house1, test="Chisq")

## Use vuongtest() instead
vuongtest(house2, house1)

## Application to models with different distributional assumptions
require(pscl)
bio1 <- glm(art ~ fem + mar + phd + ment, family=poisson, data=bioChemists)
bio2 <- hurdle(art ~ fem + mar + phd + ment, data=bioChemists)
bio3 <- zeroinfl(art ~ fem + mar + phd + ment, data=bioChemists)
vuongtest(bio2, bio1)
vuongtest(bio3, bio1)
vuongtest(bio1, bio2)
vuongtest(bio1, bio3)
vuongtest(bio3, bio2)
## Application to latent variable models
require(lavaan)
HS.model <- 'visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '
fit1 <- cfa(HS.model, data=HolzingerSwineford1939)
fit2 <- cfa(HS.model, data=HolzingerSwineford1939, group="school")
vuongtest(fit1, fit2)
}
}
\author{
Ed Merkle and Dongjun You
}
\references{
Vuong, Q. H. (1989).  Likelihood ratio tests for model selection and non-nested hypotheses.  \emph{Econometrica, 57}, 307-333.

Merkle, E. C., You, D., & Preacher, K. (2014). Testing non-nested structural equation models.  \emph{Manuscript under review}.
}

