% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_tidy_dbf.R
\name{min_max_norm}
\alias{min_max_norm}
\title{Title: Min-Max normalization of attributes that require normalization}
\usage{
min_max_norm(x)
}
\arguments{
\item{x}{A single value from an attribute passed in the function for normalization.}
}
\value{
A normalized value (value between 1 and 0)
}
\description{
Title: Min-Max normalization of attributes that require normalization
}
\note{
lapply is needed to apply the function across several columns in a data set.
}
\examples{
test_df <- as.data.frame(c(seq(40)))
colnames(test_df) <- "test"
test_df_norm <- lapply(test_df[1:ncol(test_df)], min_max_norm)
}
\references{
https://www.statology.org/how-to-normalize-data-in-r/
}
\author{
Tingwei Adeck (Adapted from Statology)
}
