% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluor_threshold_check.R
\name{fluor_threshold_check_raw}
\alias{fluor_threshold_check_raw}
\title{Title: A fluorescence quantification Quality Control (QC) function.}
\usage{
fluor_threshold_check_raw(clean_df, fun = NA)
}
\arguments{
\item{clean_df}{A cleaned data frame.}

\item{fun}{A parameter used for Boolean expressions.}
}
\value{
A polite warning message to the data analyst or researcher.
}
\description{
A function designed to check that fluorescence values do not exceed the upper limit (2^15 or 32768)
OR fall below the lower limit (2^11 or 2048).
Fluorescence values that exceed these thresholds are considered noisy
and lead to incorrect interpretation of analysis results.
}
\note{
This function works on a different type of data frame but in a similar manner to @seealso \code{\link[=fluor_threshold_check]{fluor_threshold_check()}}.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
fluor_threshold_check_raw(nocomma_dat)
}
\seealso{
\code{\link[=fluor_threshold_check]{fluor_threshold_check()}}, \code{\link[=fluor_threshold_check_na]{fluor_threshold_check_na()}}
}
\author{
Tingwei Adeck
}
