% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normfluordbf.R
\name{normfluordbf}
\alias{normfluordbf}
\title{Title: Cleans and Normalizes DBF files obtained from experiments using the FLUOstar microplate reader.}
\usage{
normfluordbf(file = NULL, norm_scale = NULL, transformed = NULL, fun = NA, ...)
}
\arguments{
\item{file}{A string ("liposomes_xxx.dbf") if the file is found within the present working directory (pwd) OR a path pointing directly to a ".dbf" file, from FLUOstar experiments.}

\item{norm_scale}{This parameter can taken in 'hundred', 'one', or 'z-score' which denotes the normalization type; Initialized as NULL.}

\item{transformed}{This parameter can take in 'log' which denotes a logarithmic box-cox transformation; Initialized as NULL.}

\item{fun}{A variable defined as NA, used for boolean expressions or manipulation.}

\item{...}{A container object that can be used to capture extra variables if needed.}
}
\value{
A normalized data frame with an appended "Cycle_Number" attribute.
}
\description{
Input the path to a ".dbf" file obtained from the FLUOstar microplate (usually a 96-well microplate) reader;
this function will create a data frame, clean the data frame,
normalize the data frame, append a "Cycle_Number" column and
return a data frame that is ready for analysis.
Most importantly, this function is a single_step function.
Also, the function can be extended to other ".dbf" files if
they follow the format for which this function was designed;
this is totally at the users' discretion.
}
\note{
Re-nomenclature of norm_tidy_dbf to a more appropriate name that facilitates function utilization. Users can continue with the old name ("norm_tidy_dbf") but this is a better name in my opinion.
}
\examples{
fpath <- system.file("extdata", "liposomes_214.dbf", package = "normfluodbf", mustWork = TRUE)
normalized_dbf <- normfluordbf(file=fpath, norm_scale = 'raw')
}
\author{
Tingwei Adeck
}
