% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epps_test.R
\name{epps.test}
\alias{epps.test}
\title{The Epps and Pulley Test for normality.}
\usage{
epps.test(y)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}
}
\value{
a h.test class with the main results of the Epps hypothesis test. The
h.test class have the following values:
\itemize{
 \item{"epps"}{The Epps statistic}
 \item{"df"}{The test degrees freedoms}
 \item{"p.value"}{The p value}
 \item{"alternative"}{The alternative hypothesis}
 \item{"method"}{The used method}
 \item{"data.name"}{The data name.}
}
}
\description{
Performs the Epps test for normality. The null hypothesis (H0) is that the given data
follows a stationary Gaussian process.
}
\details{
The Epps test minimize the process' empirical characteristic function using a
quadratic loss in terms of the process two first moments. The test was proposed
by \emph{Epps, T.W. (1987)} and implemented by \emph{Nieto-Reyes, A.,
Cuesta-Albertos, J. & Gamboa, F. (2014)} using the \code{amoebam()} function of
\emph{Press, W.H., Teukolsky, S.A., Vetterling, W.T. and  Flannery, B.P. (2007)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
epps.test(y)

}
\references{
Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.

Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Press, W.H., Teukolsky, S.A., Vetterling, W.T. and  Flannery, B.P. (2007).
Numerical Recipes. The Art of Scientific Computing. \emph{Cambridge
University Press}.
}
\seealso{
\code{\link{lobato.test}}
}
\author{
Asael Alonzo Matamoros and Alicia Nieto-Reyes.
}
