% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nosoiSim.R
\name{nosoiSim}
\alias{nosoiSim}
\title{Top-level function to use \code{nosoi}.}
\usage{
nosoiSim(type = "single", popStructure = "none", ...)
}
\arguments{
\item{type}{specifies which type of pathogen we are interested in, either "single" or "dual"-host (e.g. arboviruses).}

\item{popStructure}{specifies if the population in which the transmission is to occur is structured ("none", "discrete" or "continuous").}

\item{...}{arguments to be passed on to the chosen simulator itself, such as \code{\link{singleNone}}, \code{\link{singleDiscrete}}, \code{\link{singleContinuous}}, \code{\link{dualNone}}, \code{\link{dualDiscrete}} or \code{\link{dualContinuous}}.}
}
\value{
An object of class \code{nosoiSim}, containing all results of the simulation. Class \code{nosoiSim} object have the following slots:
\describe{
   \item{total.time}{Number of time steps the simulation ran (integer).}

   \item{type}{String giving the simulation type ("single" or "dual" host).}

   \item{host.info.A: object of class \code{nosoiSimOne}}{
       \describe{
          \item{N.infected}{Number of infected hosts (integer).}
          \item{table.hosts}{Table containing the results of the simulation  (see \code{\link{getTableHosts}} for more details on the table).}
          \item{table.state}{Table containing the results of the simulation, focusing on the movement history of each host (see \code{\link{getTableState}} for more details on the table).}
          \item{prefix.host}{String containing the prefix used to name hosts (character string).}
          \item{popStructure}{String giving the population structure (one of "none", "discrete" or "continuous").}
   }}

   \item{host.info.B: object of class \code{nosoiSimOne}}{
   Same structure as \code{host.info.A}, but for host B (if it exists).
   }
   }
}
\description{
This function determines which general settings the user wants to use for his simulation. All other arguments are passed down to the chosen simulator itself, such as \code{\link{singleNone}}, \code{\link{singleDiscrete}}, \code{\link{singleContinuous}}, \code{\link{dualNone}}, \code{\link{dualDiscrete}} or \code{\link{dualContinuous}}.
}
\examples{
\donttest{
t_incub_fct <- function(x){rnorm(x,mean = 5,sd=1)}
p_max_fct <- function(x){rbeta(x,shape1 = 5,shape2=2)}
p_Exit_fct  <- function(t){return(0.08)}

proba <- function(t,p_max,t_incub){
 if(t <= t_incub){p=0}
 if(t >= t_incub){p=p_max}
 return(p)
}

time_contact = function(t){round(rnorm(1, 3, 1), 0)}

test.nosoi <- nosoiSim(type="single", popStructure="none",
                      length=40,
                      max.infected=100,
                      init.individuals=1,
                      nContact=time_contact,
                      param.nContact=NA,
                      pTrans = proba,
                      param.pTrans = list(p_max=p_max_fct,
                                          t_incub=t_incub_fct),
                      pExit=p_Exit_fct,
                      param.pExit=NA)
test.nosoi
}

}
\seealso{
\describe{
  \item{Individual simulation functions:}{
    \code{\link{singleNone}}, \code{\link{singleDiscrete}},
    \code{\link{singleContinuous}}, \code{\link{dualNone}},
    \code{\link{dualDiscrete}} and \code{\link{dualContinuous}}.
    }
    \item{Functions to extract the results:}{
    \code{\link{getTableHosts}}, \code{\link{getTableState}}
    }
    \item{Summary statistics functions:}{
    \code{\link{nosoiSummary}},
    \code{\link{getCumulative}}, \code{\link{getDynamic}}, \code{\link{getR0}}
    }
}
}
